/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.cache;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.mentawai.cache.Cache;

public abstract class AbstractCache
implements Cache,
Serializable {
    protected static final float LOAD = 0.75f;
    protected final String name;
    protected final Map<Object, Object> map;
    protected final int capacity;
    protected volatile transient int misses = 0;
    protected volatile transient int hits = 0;
    protected final transient Date startDate = new Date();

    public AbstractCache(String name, int capacity) {
        this(name, capacity, 0.75f);
    }

    public AbstractCache(String name, int capacity, float load) {
        this.name = name;
        this.capacity = capacity;
        int initialCapacity = (int)Math.ceil((float)capacity / load) + 1;
        this.map = this.createMap(initialCapacity, load);
    }

    protected abstract Map<Object, Object> createMap(int var1, float var2);

    @Override
    public synchronized Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized Object get(Object key) {
        Object obj = this.map.get(key);
        if (obj == null) {
            ++this.misses;
        } else {
            ++this.hits;
        }
        return obj;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int getSize() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("NAME=").append(this.name).append("\n");
        sb.append("STARTDATE=").append(this.startDate).append("\n");
        sb.append("CAPACITY=").append(this.capacity).append("\n");
        sb.append("SIZE=").append(this.getSize()).append("\n");
        int misses = this.misses;
        int hits = this.hits;
        int total = misses + hits;
        sb.append("MISSES=").append(misses).append("\n");
        sb.append("HITS=").append(hits).append("\n");
        sb.append("TOTAL=").append(total).append("\n");
        if (this.getSize() < 25) {
            sb.append("ELEMENTS: ");
            AbstractCache abstractCache = this;
            synchronized (abstractCache) {
                for (Object value : this.map.values()) {
                    sb.append("[").append(value).append("]");
                }
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

