/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.authorization;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.mentawai.authorization.Permission;

public class Group
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String name;
    private Set<Permission> permissions;

    public Group(String name) {
        this.id = -1;
        this.name = name;
    }

    public Group(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Group(String name, Set<Object> permissions) {
        this(name);
        this.permissions = Group.getPermissions(permissions);
    }

    public Group(int id, String name, Set<Object> permissions) {
        this(id, name);
        this.permissions = Group.getPermissions(permissions);
    }

    public Group(int id, String name, String ... permissions) {
        this(id, name);
        if (permissions != null) {
            this.permissions = new HashSet<Permission>();
            for (int i = 0; i < permissions.length; ++i) {
                this.permissions.add(new Permission(permissions[i]));
            }
        }
    }

    public Group(String name, String ... permissions) {
        this(-1, name, permissions);
    }

    public Group(int id, String name, Permission ... permissions) {
        this(id, name);
        if (permissions != null) {
            this.permissions = new HashSet<Permission>();
            for (int i = 0; i < permissions.length; ++i) {
                this.permissions.add(permissions[i]);
            }
        }
    }

    public Group(String name, Permission ... permissions) {
        this(-1, name, permissions);
    }

    public Group(String name, String permissions) {
        this(name);
        StringTokenizer st = new StringTokenizer(permissions, ",");
        this.permissions = new HashSet<Permission>(st.countTokens());
        while (st.hasMoreTokens()) {
            this.permissions.add(new Permission(st.nextToken().trim()));
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public int getId() {
        return this.id;
    }

    private static Set<Permission> getPermissions(Set<Object> permissions) {
        HashSet<Permission> set = new HashSet<Permission>();
        for (Object obj : permissions) {
            if (obj instanceof Permission) {
                set.add((Permission)obj);
                continue;
            }
            if (obj instanceof String) {
                set.add(new Permission((String)obj));
                continue;
            }
            throw new IllegalArgumentException("Not a string or a permission: " + obj);
        }
        return set;
    }

    public Group addPermission(String permission) {
        return this.addPermission(new Permission(permission));
    }

    public Group addPermission(Permission p) {
        if (this.permissions == null) {
            this.permissions = new HashSet<Permission>();
        }
        this.permissions.add(p);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPermission(String permission) {
        if (this.permissions == null) {
            return false;
        }
        for (Permission p : this.permissions) {
            if (permission.startsWith("!")) {
                if (!p.getName().equalsIgnoreCase(permission.substring(1))) continue;
                return false;
            }
            if (!p.getName().equalsIgnoreCase(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Permission p) {
        if (this.permissions == null) {
            return false;
        }
        return this.permissions.contains(p);
    }

    public String toString() {
        if (this.id != -1) {
            return this.id + ": " + this.name;
        }
        return this.name;
    }

    public int hashCode() {
        if (this.id != -1) {
            return this.id;
        }
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group) {
            Group g = (Group)obj;
            if (g.id != -1 && this.id != -1) {
                return g.id == this.id;
            }
            if (g.name.equalsIgnoreCase(this.name)) {
                return true;
            }
        }
        return false;
    }
}

