/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.authorization;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mentawai.authorization.AuthorizationManager;
import org.mentawai.authorization.Group;

public class DBAuthorizationGroup {
    private Group group;
    private List<Group> list;
    private StringBuffer sql = null;
    private String tableGroup = null;
    private String keyGroup = null;
    private String valueGroup = null;
    private String tableReference = null;
    private String keyPermissionReference = null;
    private String keyGroupReference = null;
    private String tablePermission = null;
    private String keyPermission = null;
    private String valuePermission = null;
    private String sqlWhere = null;

    public DBAuthorizationGroup(String sql) {
        this.sql = new StringBuffer(sql);
        this.list = null;
    }

    public DBAuthorizationGroup(String tableGroup, String keyGroup, String valueGroup) {
        this.tableGroup = tableGroup;
        this.keyGroup = keyGroup;
        this.valueGroup = valueGroup;
        this.list = null;
    }

    public DBAuthorizationGroup(String tableGroup, String keyGroup, String valueGroup, String sqlWhere) {
        this.tableGroup = tableGroup;
        this.keyGroup = keyGroup;
        this.valueGroup = valueGroup;
        this.sqlWhere = sqlWhere;
        this.list = null;
    }

    public DBAuthorizationGroup(String tableGroup, String keyGroup, String valueGroup, String tablePermission, String valuePermission) {
        this.tableGroup = tableGroup;
        this.keyGroup = keyGroup;
        this.valueGroup = valueGroup;
        this.valuePermission = valuePermission;
        this.list = null;
    }

    public DBAuthorizationGroup(String tableGroup, String keyGroup, String valueGroup, String tablePermission, String valuePermission, String sqlWhere) {
        this.tableGroup = tableGroup;
        this.keyGroup = keyGroup;
        this.valueGroup = valueGroup;
        this.valuePermission = valuePermission;
        this.sqlWhere = sqlWhere;
        this.list = null;
    }

    public DBAuthorizationGroup(String tableGroup, String keyGroup, String valueGroup, String tableReference, String keyPermissionReference, String keyGroupReference, String tablePermission, String keyPermission, String valuePermission) {
        this.tableGroup = tableGroup;
        this.keyGroup = keyGroup;
        this.valueGroup = valueGroup;
        this.tableReference = tableReference;
        this.keyPermissionReference = keyPermissionReference;
        this.keyGroupReference = keyGroupReference;
        this.tablePermission = tablePermission;
        this.keyPermission = keyPermission;
        this.valuePermission = valuePermission;
        this.list = null;
    }

    public DBAuthorizationGroup(String tableGroup, String keyGroup, String valueGroup, String tableReference, String keyPermissionReference, String keyGroupReference, String tablePermission, String keyPermission, String valuePermission, String sqlWhere) {
        this.tableGroup = tableGroup;
        this.keyGroup = keyGroup;
        this.valueGroup = valueGroup;
        this.tableReference = tableReference;
        this.keyPermissionReference = keyPermissionReference;
        this.keyGroupReference = keyGroupReference;
        this.tablePermission = tablePermission;
        this.keyPermission = keyPermission;
        this.valuePermission = valuePermission;
        this.sqlWhere = sqlWhere;
        this.list = null;
    }

    protected String buildSQL() {
        if (this.sql == null) {
            this.sql = new StringBuffer("select " + this.tableGroup + "." + this.keyGroup + ", " + this.tableGroup + "." + this.valueGroup);
            if (this.tablePermission != null) {
                this.sql.append(" , " + this.tablePermission + "." + this.valuePermission);
            }
            this.sql.append(" from " + this.tableGroup);
            if (this.tablePermission != null) {
                this.sql.append(", " + this.tablePermission);
            }
            if (this.tableReference != null) {
                this.sql.append(" , " + this.tableReference + " where " + this.tablePermission + "." + this.keyPermission + " = " + this.tableReference + "." + this.keyPermissionReference + " and " + this.tableReference + "." + this.keyGroupReference + " = " + this.tableGroup + "." + this.keyGroup + (this.sqlWhere != null ? this.sqlWhere : "") + " order by 1, 2, 3 asc");
            } else {
                this.sql.append(this.sqlWhere != null ? " " + this.sqlWhere : "");
            }
        }
        return this.sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rset = null;
        String sql = this.buildSQL();
        try {
            stmt = conn.prepareStatement(sql);
            rset = stmt.executeQuery();
            while (rset.next()) {
                this.keyGroup = rset.getString(1);
                this.valueGroup = rset.getString(2);
                if (this.tablePermission != null) {
                    String string = this.valuePermission = rset.getString(3) != null ? rset.getString(3) : null;
                }
                if (rset.isFirst()) {
                    this.addNewGroup(this.keyGroup, this.valueGroup, this.valuePermission);
                } else if (this.group.getName().equalsIgnoreCase(this.valueGroup) && this.valuePermission != null) {
                    this.addPermission(this.valuePermission);
                } else {
                    AuthorizationManager.addGroup(this.group);
                    this.addNewGroup(this.keyGroup, this.valueGroup, this.valuePermission);
                }
                if (!rset.isLast()) continue;
                AuthorizationManager.addGroup(this.group);
            }
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> loadGroupList(Connection conn) throws SQLException {
        this.list = new ArrayList<Group>(1000);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        String sql = this.buildSQL();
        try {
            stmt = conn.prepareStatement(sql);
            rset = stmt.executeQuery();
            while (rset.next()) {
                this.keyGroup = rset.getString(1);
                this.valueGroup = rset.getString(2);
                if (this.tablePermission != null) {
                    String string = this.valuePermission = rset.getString(3) != null ? rset.getString(3) : null;
                }
                if (rset.isFirst()) {
                    this.addNewGroup(this.keyGroup, this.valueGroup, this.valuePermission);
                } else if (this.group.getName().equalsIgnoreCase(this.valueGroup) && this.valuePermission != null) {
                    this.addPermission(this.valuePermission);
                } else {
                    this.addGroupToListGroup(this.group);
                    this.addNewGroup(this.keyGroup, this.valueGroup, this.valuePermission);
                }
                if (!rset.isLast()) continue;
                this.addGroupToListGroup(this.group);
            }
            List<Group> list = this.list;
            return list;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void addNewGroup(String kGroup, String vGroup, String vPermission) {
        this.group = vGroup == null && vPermission == null ? new Group(vGroup) : (vPermission == null ? new Group(Integer.parseInt(kGroup), vGroup) : new Group(Integer.parseInt(kGroup), vGroup).addPermission(vPermission));
    }

    private void addPermission(String vPermission) {
        if (vPermission == null) {
            this.group.addPermission(vPermission);
        }
    }

    private void addGroupToListGroup(Group g) {
        if (g != null) {
            this.list.add(g);
        }
    }
}

