/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.authorization;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.authorization.Group;
import org.mentawai.core.Context;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.list.ListData;
import org.mentawai.list.ListItem;

public class AuthorizationManager
implements Serializable {
    protected static Set<Group> groups = new HashSet<Group>();
    protected static Map<String, Group> groupsMap = new HashMap<String, Group>();
    protected static Map<Integer, Group> groupsMapId = new HashMap<Integer, Group>();

    public static void addListGroup(ListData data) {
        List<ListItem> list = data.getValues(LocaleManager.getDefaultLocale());
        for (ListItem item : list) {
            String key = item.getKey();
            try {
                AuthorizationManager.addGroup(new Group(Integer.parseInt(key), item.getValue()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("List data has non-integer keys: " + key);
            }
        }
    }

    public static void addGroup(Group g) {
        groups.add(g);
        groupsMap.put(g.getName(), g);
        if (g.getId() != -1) {
            groupsMapId.put(g.getId(), g);
        }
    }

    public static boolean hasGroup(Group g) {
        return groups.contains(g);
    }

    public static boolean hasGroup(String name) {
        return groupsMap.containsKey(name);
    }

    public static boolean hasGroup(int id) {
        return groupsMapId.containsKey(id);
    }

    public static Group getGroup(String groupName) {
        return groupsMap.get(groupName);
    }

    public static Group getGroup(int id) {
        return groupsMapId.get(id);
    }

    public static boolean check(String group, String permission) {
        Group g = AuthorizationManager.getGroup(group);
        if (g != null) {
            return g.hasPermission(permission);
        }
        return false;
    }

    public static boolean checkAny(String group, List<String> permissions) {
        Iterator<String> iter = permissions.iterator();
        boolean ok = false;
        while (iter.hasNext()) {
            String permission = iter.next();
            if (permission.startsWith("!")) {
                if (!AuthorizationManager.check(group, permission.substring(1))) continue;
                return false;
            }
            if (!AuthorizationManager.check(group, permission)) continue;
            ok = true;
        }
        return ok;
    }

    public static boolean check(Group group, String permission) {
        if (group != null) {
            return group.hasPermission(permission);
        }
        return false;
    }

    public static boolean checkAny(Group group, List<String> permissions) {
        Iterator<String> iter = permissions.iterator();
        boolean ok = false;
        while (iter.hasNext()) {
            String permission = iter.next();
            if (permission.startsWith("!")) {
                if (!AuthorizationManager.check(group, permission.substring(1))) continue;
                return false;
            }
            if (!AuthorizationManager.check(group, permission)) continue;
            ok = true;
        }
        return ok;
    }

    public static void setUserGroup(String group, Context session) {
        BaseLoginAction.setUserGroup(group, session);
    }

    public static void setUserGroups(List groups, Context session) {
        BaseLoginAction.setUserGroups(groups, session);
    }

    public static void setUserGroup(Group g, Context session) {
        BaseLoginAction.setUserGroup(g, session);
    }

    public static void setUserGroup(int groupId, Context session) {
        BaseLoginAction.setUserGroup(groupId, session);
    }

    public static void setUserGroups(String groups, Context session) {
        BaseLoginAction.setUserGroups(groups, session);
    }
}

