/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajaxtag.renders;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mentawai.ajaxtag.AjaxtagConstraints;
import org.mentawai.ajaxtag.renders.CalloutAjaxtagRender;
import org.mentawai.ajaxtag.renders.FormAjaxtagRender;
import org.mentawai.ajaxtag.renders.HtmlContentAjaxtagRender;
import org.mentawai.ajaxtag.renders.ListDataAjaxtagRender;
import org.mentawai.ajaxtag.responses.BaseAjaxtagResponse;
import org.mentawai.util.InjectionUtils;

public abstract class AjaxtagRender {
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML = "text/xml";
    private static final Map<AjaxtagConstraints, AjaxtagRender> renders;

    public abstract String renderize(BaseAjaxtagResponse var1, Locale var2) throws Exception;

    public String getContentType() {
        return TEXT_XML;
    }

    public String getProperty(Object bean, String nameProperty) throws Exception {
        if (bean == null) {
            return "null";
        }
        String value = InjectionUtils.getProperty(bean, nameProperty);
        if (value == null) {
            return bean.toString();
        }
        return value;
    }

    public static AjaxtagRender getRender(AjaxtagConstraints constraint) {
        return renders.get((Object)constraint);
    }

    static {
        HashMap<AjaxtagConstraints, AjaxtagRender> map = new HashMap<AjaxtagConstraints, AjaxtagRender>();
        map.put(AjaxtagConstraints.HTML, new HtmlContentAjaxtagRender());
        map.put(AjaxtagConstraints.STRING, new CalloutAjaxtagRender());
        map.put(AjaxtagConstraints.FORM, new FormAjaxtagRender());
        map.put(AjaxtagConstraints.LISTDATA, new ListDataAjaxtagRender());
        renders = Collections.unmodifiableMap(map);
    }
}

