/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajaxtag;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.ajaxtag.AjaxtagConstraints;
import org.mentawai.ajaxtag.BaseAjaxtagAction;
import org.mentawai.ajaxtag.responses.BaseAjaxtagResponse;
import org.mentawai.ajaxtag.responses.ErrorResponse;
import org.mentawai.core.Action;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.log.Error;
import org.mentawai.util.HttpUtils;

public class AjaxtagErrorConsequence
implements Consequence {
    @Override
    public void execute(Action a, String result, HttpServletRequest req, HttpServletResponse res) throws ConsequenceException {
        HttpUtils.disableCache(res);
        BaseAjaxtagAction ba = (BaseAjaxtagAction)a;
        BaseAjaxtagResponse response = ba.getResponse();
        if (response == null) {
            AjaxtagErrorConsequence.sendError(res, null);
            return;
        }
        AjaxtagConstraints constraint = response.getConstraints();
        if (constraint == AjaxtagConstraints.ERROR) {
            ErrorResponse r = (ErrorResponse)response;
            AjaxtagErrorConsequence.sendError(res, r.getException());
        } else {
            AjaxtagErrorConsequence.sendError(res, null);
        }
    }

    static void sendError(HttpServletResponse res, Exception exception) throws ConsequenceException {
        Error.log("An error has occuried on the ajaxtag renderization!", exception);
        String msg = "";
        if (exception != null) {
            msg = exception.getMessage();
        }
        try {
            res.sendError(500, "An error has occuried on the ajaxtag process: " + msg);
        }
        catch (IOException e1) {
            Error.log("Exception while writing to send an error: " + e1.getMessage(), e1);
            throw new ConsequenceException("Exception while writing to send an error: " + e1.getMessage(), e1);
        }
    }
}

