/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajaxtag;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.ajaxtag.AjaxtagConstraints;
import org.mentawai.ajaxtag.AjaxtagErrorConsequence;
import org.mentawai.ajaxtag.renders.AjaxtagRender;
import org.mentawai.ajaxtag.responses.BaseAjaxtagResponse;
import org.mentawai.core.Action;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.util.HttpUtils;

public class AjaxtagConsequence
implements Consequence {
    @Override
    public void execute(Action a, String result, HttpServletRequest req, HttpServletResponse res) throws ConsequenceException {
        HttpUtils.disableCache(res);
        BaseAjaxtagResponse response = (BaseAjaxtagResponse)a.getOutput().getValue("ajaxtag_response");
        if (response == null) {
            return;
        }
        response.setRequest(req);
        response.setResponse(res);
        AjaxtagConstraints constraint = response.getConstraints();
        AjaxtagRender ajaxRender = AjaxtagRender.getRender(constraint);
        res.setContentType(ajaxRender.getContentType());
        try {
            String answer = ajaxRender.renderize(response, a.getLocale());
            PrintWriter writer = res.getWriter();
            writer.print(answer);
            writer.flush();
        }
        catch (IOException e) {
            throw new ConsequenceException("Exception while getting printer! " + e.getMessage(), e);
        }
        catch (Exception e) {
            AjaxtagErrorConsequence.sendError(res, e);
        }
    }
}

