/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax.renderer;

import com.thoughtworks.xstream.XStream;
import java.util.Locale;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;

public class XStreamRenderer
implements AjaxRenderer {
    private final XStream xstream;
    private final String contentType;

    public XStreamRenderer() {
        this(new XStream(), "text/xml");
    }

    public XStreamRenderer(XStream xstream) {
        this(xstream, "text/xml");
    }

    public XStreamRenderer(String contentType) {
        this(new XStream(), contentType);
    }

    public XStreamRenderer(XStream xstream, String contentType) {
        if (xstream == null) {
            throw new IllegalArgumentException("The attribute 'xStream' cannot be null!");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("The attribute 'contentType' cannot be null!");
        }
        this.xstream = xstream;
        this.contentType = contentType;
    }

    @Override
    public String encode(Object obj, Locale loc, boolean prettty) throws Exception {
        return this.xstream.toXML(obj);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getCharset() {
        return AjaxConsequence.DEFAULT_CHARSET;
    }
}

