/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax.renderer;

import java.util.Locale;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;

public class StringAjaxRenderer
implements AjaxRenderer {
    private static final String DEFAULT_TAG_NAME = "value";
    private String tagName;

    public StringAjaxRenderer() {
        this.tagName = DEFAULT_TAG_NAME;
    }

    public StringAjaxRenderer(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public String encode(Object obj, Locale loc, boolean pretty) throws Exception {
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Value is not a String: " + obj);
        }
        String value = (String)obj;
        StringBuilder buffer = new StringBuilder();
        buffer.append('<').append(this.tagName).append('>').append(value).append("</").append(this.tagName).append('>');
        return buffer.toString();
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public String getCharset() {
        return AjaxConsequence.DEFAULT_CHARSET;
    }
}

