/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax.renderer;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;
import org.mentawai.ajax.DOMUtils;

public class MapAjaxRenderer
implements AjaxRenderer {
    public static final String FATHER = "map";
    public static final String CHILD = "entry";
    public static final String KEY = "key";
    private String root;
    private String child;
    private String key;

    public MapAjaxRenderer(String root, String child, String key) {
        this.root = root;
        this.child = child;
        this.key = key;
    }

    public MapAjaxRenderer() {
        this.root = FATHER;
        this.child = CHILD;
        this.key = KEY;
    }

    @Override
    public String encode(Object obj, Locale loc, boolean pretty) throws Exception {
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException("Value is not a Map: " + obj);
        }
        Map map = (Map)obj;
        Document document = new Document();
        Element mapElement = new Element(this.root);
        for (Map.Entry element : map.entrySet()) {
            Element child = new Element(this.child);
            Map.Entry entry = element;
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            child.setAttribute(this.key, key);
            child.setText(value);
            mapElement.addContent((Content)child);
        }
        document.setRootElement(mapElement);
        return DOMUtils.getDocumentAsString(document, pretty);
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public String getCharset() {
        return AjaxConsequence.DEFAULT_CHARSET;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sergio", "sergio@sergio.com.br");
        map.put("patty", "patty@patty.com.br");
        MapAjaxRenderer render = new MapAjaxRenderer("usuarios", "usuario", "username");
        System.out.println(render.encode(map, new Locale("en"), true));
    }
}

