/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax.renderer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;
import org.mentawai.ajax.renderer.JSONMapAjaxRenderer;
import org.mentawai.core.ConsequenceException;

public class JsonRenderer
implements AjaxRenderer {
    @Override
    public String encode(Object obj, Locale loc, boolean pretty) throws Exception {
        JSONObject json = null;
        JSONArray jsonArray = null;
        if (obj instanceof Map) {
            json = JSONObject.fromObject((Object)obj);
        } else if (obj instanceof List) {
            jsonArray = JSONArray.fromObject((Object)obj);
        } else if (obj instanceof JSONObject) {
            json = (JSONObject)obj;
        } else {
            throw new ConsequenceException("Value is not a Collection or JSONObject: " + obj);
        }
        if (pretty) {
            if (json != null) {
                return json.toString(3);
            }
            return jsonArray.toString(3);
        }
        if (json != null) {
            return json.toString();
        }
        return jsonArray.toString();
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getCharset() {
        return AjaxConsequence.DEFAULT_CHARSET;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("success", Boolean.valueOf(true));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("key1", "data1");
        data.put("key2", "data2");
        data.put("key3", "data3");
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("pela1", "xxxx");
        data2.put("pela2", "yyyy");
        data.put("key4", data2);
        map.put("data", data);
        JSONMapAjaxRenderer renderer = new JSONMapAjaxRenderer();
        System.out.println(renderer.encode(map, null, true));
    }
}

