/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax.renderer;

import java.util.Locale;
import net.sf.json.JSONObject;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;

public class JSONObjectAjaxRenderer
implements AjaxRenderer {
    @Override
    public String encode(Object obj, Locale loc, boolean pretty) throws Exception {
        JSONObject json = JSONObject.fromObject((Object)obj);
        if (pretty) {
            return json.toString(3);
        }
        return json.toString();
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getCharset() {
        return AjaxConsequence.DEFAULT_CHARSET;
    }

    public static void main(String[] args) throws Exception {
        User u = new User("sergio", 34);
        JSONObjectAjaxRenderer renderer = new JSONObjectAjaxRenderer();
        System.out.println(renderer.encode(u, null, true));
    }

    public static class User {
        private String username;
        private int age;

        public User(String username, int age) {
            this.username = username;
            this.age = age;
        }

        public String getUsername() {
            return this.username;
        }

        public int getAge() {
            return this.age;
        }
    }
}

