/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax.renderer;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;
import org.mentawai.core.MapOutput;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.list.ListData;
import org.mentawai.list.ListItem;
import org.mentawai.util.InjectionUtils;
import org.mentawai.util.MentaJson;

public class JSONGenericRenderer
implements AjaxRenderer {
    String dateFormat = null;
    private int levels = 0;
    private int currentLevel = 0;
    private static List<String> excludedProperties = new ArrayList<String>();

    public JSONGenericRenderer() {
    }

    public JSONGenericRenderer(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public JSONGenericRenderer(int levels) {
        this.levels = levels;
    }

    public JSONGenericRenderer(String dateFormat, int levels) {
        this(dateFormat);
        this.levels = levels;
    }

    @Override
    public String encode(Object object, Locale loc, boolean pretty) throws Exception {
        if (object instanceof String) {
            return object.toString();
        }
        return this.buildJSON(object, loc).toString();
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public String getCharset() {
        return AjaxConsequence.DEFAULT_CHARSET;
    }

    protected JSONObject buildJSON(Object obj, Locale loc) {
        try {
            if (obj instanceof Map) {
                JSONObject jsonObj = MentaJson.getJSONObject();
                jsonObj.put((Object)"obj", (Object)this.convertMap((Map)obj, loc));
                return jsonObj;
            }
            if (obj instanceof Collection) {
                JSONObject jsonObj = MentaJson.getJSONObject();
                jsonObj.put((Object)"obj", (Object)this.convertListBean((Collection)obj, loc));
                return jsonObj;
            }
            if (obj instanceof ListData) {
                JSONObject jsonObj = MentaJson.getJSONObject();
                jsonObj.put((Object)"obj", (Object)this.convertListData((ListData)obj, loc));
                return jsonObj;
            }
            JSONArray jsonArray = MentaJson.getJSONArray();
            jsonArray.add((Object)this.convertBean(obj, loc));
            JSONObject jsonObj = MentaJson.getJSONObject();
            jsonObj.put((Object)"obj", (Object)jsonArray);
            return jsonObj;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONArray convertListData(ListData listData, Locale loc) {
        List<ListItem> itens = listData.getValues(loc);
        JSONArray jsa = MentaJson.getJSONArray();
        for (ListItem listItem : itens) {
            try {
                JSONObject jso = MentaJson.getJSONObject();
                jso.put((Object)"key", (Object)listItem.getKey());
                jso.put((Object)"value", (Object)listItem.getValue());
                jsa.add((Object)jso);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsa;
    }

    private Object parseDate(Object value, Locale loc) {
        String result = null;
        if (value != null) {
            if (this.dateFormat == null) {
                SimpleDateFormat sdf = LocaleManager.getSimpleDateFormat(loc);
                if (sdf != null) {
                    result = sdf.format(value);
                }
            } else {
                result = new SimpleDateFormat(this.dateFormat).format(value);
            }
        }
        return result;
    }

    private JSONObject convertBean(Object bean, Locale loc) {
        MapOutput om = new MapOutput();
        InjectionUtils.setObject(bean, om, null, false);
        Iterator<String> interator = om.keys();
        JSONObject jsonObj = MentaJson.getJSONObject();
        while (interator.hasNext()) {
            String propertyName = interator.next();
            if (excludedProperties.contains(propertyName)) continue;
            Object value = om.getValue(propertyName);
            if (value instanceof Date) {
                value = this.parseDate(value, loc);
            } else if (value instanceof Calendar) {
                value = this.parseDate(((Calendar)value).getTime(), loc);
            }
            if (value == null) {
                value = "";
            }
            try {
                if (JSONGenericRenderer.isValidBean(value) && !value.equals("") && this.levels > this.currentLevel) {
                    ++this.currentLevel;
                    jsonObj.put((Object)propertyName, (Object)this.convertBean(value, loc));
                    continue;
                }
                if (JSONGenericRenderer.isWrapper(value) && !JSONGenericRenderer.isValidBean(value)) {
                    jsonObj.put((Object)propertyName, (Object)value.toString());
                    continue;
                }
                if (value instanceof Collection && this.levels == 1 && this.levels > this.currentLevel) {
                    Collection list = (Collection)value;
                    jsonObj.put((Object)propertyName, (Object)this.convertListBean(new ArrayList(list), loc));
                    continue;
                }
                jsonObj.put((Object)propertyName, (Object)"");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.currentLevel = 0;
        return jsonObj;
    }

    private JSONArray convertCollection(Collection col) {
        JSONArray array = MentaJson.getJSONArray();
        for (Object object : col) {
            array.add((Object)object.toString());
        }
        return array;
    }

    private JSONArray convertListBean(Collection list, Locale loc) {
        JSONArray jsonArray = MentaJson.getJSONArray();
        for (Object object : list) {
            if (JSONGenericRenderer.isValidBean(object)) {
                jsonArray.add((Object)this.convertBean(object, loc));
                continue;
            }
            jsonArray = this.convertCollection(list);
            break;
        }
        return jsonArray;
    }

    private JSONArray convertMap(Map obj, Locale loc) {
        Map map = obj;
        Map.Entry entry2 = null;
        JSONArray jsonArray = MentaJson.getJSONArray();
        for (Map.Entry entry2 : map.entrySet()) {
            try {
                JSONObject jsonObj;
                Object value = entry2.getValue();
                if (value instanceof Map) {
                    jsonObj = MentaJson.getJSONObject();
                    jsonObj.put((Object)"key", (Object)entry2.getKey().toString());
                    jsonObj.put((Object)"value", (Object)this.convertMap((Map)value, loc));
                    jsonArray.add((Object)jsonObj);
                    continue;
                }
                if (value instanceof Collection) {
                    jsonObj = MentaJson.getJSONObject();
                    jsonObj.put((Object)"key", (Object)entry2.getKey().toString());
                    jsonObj.put((Object)"value", (Object)this.convertCollection((Collection)value));
                    jsonArray.add((Object)jsonObj);
                    continue;
                }
                if (value instanceof ListData) {
                    jsonObj = MentaJson.getJSONObject();
                    jsonObj.put((Object)"key", (Object)entry2.getKey().toString());
                    jsonObj.put((Object)"value", (Object)this.convertListData((ListData)value, loc));
                    jsonArray.add((Object)jsonObj);
                    continue;
                }
                jsonObj = MentaJson.getJSONObject();
                jsonObj.put((Object)"key", (Object)entry2.getKey().toString());
                jsonObj.put((Object)"value", entry2.getValue());
                jsonArray.add((Object)jsonObj);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonArray;
    }

    protected static boolean isWrapper(Object o) {
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            return true;
        }
        if (o instanceof Character) {
            return true;
        }
        return o instanceof Boolean;
    }

    protected static boolean isValidBean(Object o) {
        if (o.getClass().getName().startsWith("java.util.") || o.getClass().getName().startsWith("java.lang.")) {
            return false;
        }
        return !(o instanceof Collection);
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("success", Boolean.valueOf(true));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key1", "data1");
        data.put("key2", "data2");
        data.put("key3", "data3");
        map.put("data", data);
        JSONGenericRenderer renderer = new JSONGenericRenderer();
        System.out.println(renderer.encode(map, null, true));
    }

    static {
        excludedProperties.add("hibernateLazyInitializer");
    }
}

