/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import net.sf.json.JSONArray;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;

public class JSONArrayAjaxRenderer
implements AjaxRenderer {
    @Override
    public String encode(Object obj, Locale loc, boolean pretty) throws Exception {
        JSONArray json;
        if (obj instanceof Collection) {
            json = JSONArray.fromObject((Object)obj);
        } else if (obj instanceof JSONArray) {
            json = (JSONArray)obj;
        } else {
            throw new IllegalArgumentException("Value is not a Collection or JSONArray: " + obj);
        }
        if (pretty) {
            return json.toString(3);
        }
        return json.toString();
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getCharset() {
        return AjaxConsequence.DEFAULT_CHARSET;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> coll = new ArrayList<String>(3);
        coll.add("Sergio");
        coll.add("Rubem");
        coll.add("Robert");
        JSONArrayAjaxRenderer renderer = new JSONArrayAjaxRenderer();
        System.out.println(renderer.encode(coll, null, true));
    }
}

