/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax.renderer;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;
import org.mentawai.util.InjectionUtils;

public class BeanCollectionAjaxRenderer
implements AjaxRenderer {
    public static final String DEFAULT_ROOT_TAG = "father";
    public static final String DEFAULT_ENTRY_TAG = "child";
    private String root = "father";
    private String child = "child";
    private String[] subTagsAttrs;
    private String[] attrsAttrs;

    private void printCR(StringBuilder sb, boolean pretty) {
        if (!pretty) {
            return;
        }
        sb.append('\n');
    }

    private void printTab(StringBuilder sb, boolean pretty, int x) {
        if (!pretty) {
            return;
        }
        for (int i = 0; i < x; ++i) {
            sb.append("   ");
        }
    }

    @Override
    public String encode(Object obj, Locale loc, boolean pretty) throws Exception {
        if (!(obj instanceof Collection)) {
            throw new IllegalArgumentException("Object is not a Collection: " + obj);
        }
        Collection coll = (Collection)obj;
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(this.root).append('>');
        this.printCR(sb, pretty);
        for (Object bean : coll) {
            Method method;
            String attrName;
            int i;
            Class<?> klass = bean.getClass();
            this.printTab(sb, pretty, 1);
            sb.append('<').append(this.child);
            if (this.attrsAttrs != null) {
                for (i = 0; i < this.attrsAttrs.length; ++i) {
                    attrName = this.attrsAttrs[i];
                    method = InjectionUtils.findMethodToGet(klass, attrName);
                    if (method == null) {
                        throw new Exception("Cannot find method to get: " + klass + " / " + attrName);
                    }
                    sb.append(' ').append(attrName).append("=\"").append(method.invoke(bean, (Object[])null)).append("\"");
                }
            } else {
                sb.append(' ');
            }
            sb.append('>');
            this.printCR(sb, pretty);
            if (this.subTagsAttrs != null) {
                for (i = 0; i < this.subTagsAttrs.length; ++i) {
                    attrName = this.subTagsAttrs[i];
                    method = InjectionUtils.findMethodToGet(klass, attrName);
                    if (method == null) {
                        throw new Exception("Cannot find method to get: " + klass + " / " + attrName);
                    }
                    this.printTab(sb, pretty, 2);
                    sb.append('<').append(attrName).append('>').append(method.invoke(bean, (Object[])null)).append("</").append(attrName).append('>');
                    this.printCR(sb, pretty);
                }
            }
            this.printTab(sb, pretty, 1);
            sb.append("</").append(this.child).append('>');
            this.printCR(sb, pretty);
        }
        sb.append("</").append(this.root).append('>');
        this.printCR(sb, pretty);
        return sb.toString();
    }

    public BeanCollectionAjaxRenderer(String rootTag, String childTag, String[] subTagsAttrs, String[] attrsAttrs) {
        this.root = rootTag;
        this.child = childTag;
        this.attrsAttrs = attrsAttrs;
        this.subTagsAttrs = subTagsAttrs;
    }

    public BeanCollectionAjaxRenderer(String[] subTagsAttrs, String[] attrsAttrs) {
        this.attrsAttrs = attrsAttrs;
        this.subTagsAttrs = subTagsAttrs;
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public String getCharset() {
        return AjaxConsequence.DEFAULT_CHARSET;
    }

    public static void main(String[] args) throws Exception {
        LinkedList<User> list = new LinkedList<User>();
        list.add(new User("sergio", "soliveira", "sergio@sergio.com.br"));
        list.add(new User("patty", "pmesseder", "patty@patty.com.br"));
        BeanCollectionAjaxRenderer render = new BeanCollectionAjaxRenderer(new String[]{"name", "username", "email"}, new String[]{"email", "username", "name"});
        System.out.println(render.encode(list, new Locale("en"), true));
    }

    private static class User {
        private final String name;
        private final String username;
        private final String email;

        public User(String name, String username, String email) {
            this.name = name;
            this.username = username;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getUsername() {
            return this.username;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

