/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class DOMUtils {
    private static final XMLOutputter outputter = new XMLOutputter();
    private static final XMLOutputter outputterPretty = new XMLOutputter(Format.getPrettyFormat());

    public static final String getDocumentAsString(Document document, boolean pretty) {
        StringWriter stringWriter = new StringWriter();
        try {
            DOMUtils.writeDocument(document, stringWriter, pretty);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }

    public static final void writeDocument(Document document, OutputStream outputStream, boolean pretty) throws IOException {
        if (pretty) {
            outputterPretty.output(document, outputStream);
        } else {
            outputter.output(document, outputStream);
        }
    }

    public static final void writeDocument(Document document, Writer writer, boolean pretty) throws IOException {
        if (pretty) {
            outputterPretty.output(document, writer);
        } else {
            outputter.output(document, writer);
        }
    }
}

