/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.ajax.AjaxRenderer;
import org.mentawai.core.Action;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.core.Output;
import org.mentawai.util.DebugServletFilter;
import org.mentawai.util.HttpUtils;

public class AjaxConsequence
implements Consequence {
    public static String OBJECT = "ajax_object";
    public static String DEFAULT_CHARSET = "UTF-8";
    private String keyForObject = OBJECT;
    private final AjaxRenderer ajaxRenderer;
    private boolean pretty;

    public AjaxConsequence(AjaxRenderer renderer) {
        this(renderer, true);
    }

    public AjaxConsequence(AjaxRenderer renderer, boolean pretty) {
        this.ajaxRenderer = renderer;
        this.pretty = pretty;
    }

    public AjaxConsequence keyForObject(String key) {
        this.keyForObject = key;
        return this;
    }

    public AjaxConsequence source(String key) {
        return this.keyForObject(key);
    }

    @Override
    public void execute(Action a, String result, HttpServletRequest req, HttpServletResponse res) throws ConsequenceException {
        Output output = a.getOutput();
        Object obj = null;
        if (this.keyForObject == null || !output.has(this.keyForObject)) {
            output.removeValue(DebugServletFilter.DEBUG_KEY);
            obj = output;
        } else {
            obj = a.getOutput().getValue(this.keyForObject);
        }
        try {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.ajaxRenderer.getContentType()).append("; charset=").append(this.ajaxRenderer.getCharset());
            res.setContentType(sb.toString());
            String s = this.ajaxRenderer.encode(obj, a.getLocale(), this.pretty);
            HttpUtils.disableCache(res);
            PrintWriter printWriter = res.getWriter();
            printWriter.print(s);
            printWriter.flush();
        }
        catch (IOException e) {
            throw new ConsequenceException("Exception while writing the renderized document: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ConsequenceException("Exception while renderizing with render " + this.ajaxRenderer.getClass() + ": " + e.getMessage(), e);
        }
    }
}

