/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import org.mentawai.authorization.AuthorizationManager;
import org.mentawai.authorization.Group;
import org.mentawai.core.BaseAction;
import org.mentawai.core.Context;
import org.mentawai.filter.AuthenticationFree;

public abstract class BaseLoginAction
extends BaseAction
implements AuthenticationFree {
    public static final String USER_KEY = "sessionUser";
    public static final String GROUPS_KEY = "sessionGroups";
    public static final String LOCALE_KEY = "sessionLocale";

    @Override
    public void setUserSession(Object value) {
        BaseLoginAction.setUserSession(value, this.session);
    }

    @Override
    public void setSessionObj(Object value) {
        this.setUserSession(value);
    }

    @Override
    public void replaceUserSession(Object newUser) {
        BaseLoginAction.replaceUserSession(newUser, this.session);
    }

    @Override
    public void replaceSessionObj(Object value) {
        BaseLoginAction.replaceUserSession(value, this.session);
    }

    public static void setUserSession(Object value, Context session) {
        session.reset();
        session.setAttribute(USER_KEY, value);
    }

    public static void setSessionObj(Object value, Context session) {
        BaseLoginAction.setUserSession(value, session);
    }

    public static void replaceUserSession(Object newUser, Context session) {
        session.setAttribute(USER_KEY, newUser);
    }

    public static void replaceSessionObj(Object value, Context session) {
        BaseLoginAction.replaceUserSession(value, session);
    }

    public static void replaceUserSession(Object newUser, Map<String, Object> session) {
        if (session instanceof Context) {
            BaseLoginAction.setUserSession(newUser, (Context)((Object)session));
        } else {
            session.put(USER_KEY, newUser);
        }
    }

    public static void replaceSessionObj(Object value, Map<String, Object> session) {
        BaseLoginAction.replaceUserSession(value, session);
    }

    public static void setUserSession(Object value, Map<String, Object> session) {
        if (session instanceof Context) {
            BaseLoginAction.setUserSession(value, (Context)((Object)session));
        } else {
            session.put(USER_KEY, value);
        }
    }

    public static void setSessionObj(Object value, Map<String, Object> session) {
        BaseLoginAction.setUserSession(value, session);
    }

    public void setUserLocale(Locale loc) {
        BaseLoginAction.setUserLocale(loc, this.session);
    }

    @Override
    public void setSessionLocale(Locale loc) {
        BaseLoginAction.setUserLocale(loc, this.session);
    }

    public static void setSessionLocale(Locale loc, Context session) {
        BaseLoginAction.setUserLocale(loc, session);
    }

    @Override
    public void setSessionLocale(String loc) {
        this.setUserLocale(loc);
    }

    public static void setUserLocale(Locale loc, Context session) {
        if (!session.hasAttribute(USER_KEY)) {
            throw new IllegalStateException("Tried to set user locale, but there is no user in the session!");
        }
        session.setAttribute(LOCALE_KEY, loc);
    }

    public static void setUserLocale(String loc, Context session) {
        StringTokenizer st = new StringTokenizer(loc, "_");
        if (st.countTokens() == 1) {
            BaseLoginAction.setUserLocale(new Locale(st.nextToken()), session);
        } else if (st.countTokens() == 2) {
            BaseLoginAction.setUserLocale(new Locale(st.nextToken(), st.nextToken()), session);
        } else if (st.countTokens() == 3) {
            BaseLoginAction.setUserLocale(new Locale(st.nextToken(), st.nextToken(), st.nextToken()), session);
        } else {
            throw new IllegalArgumentException("Bad locale: " + loc);
        }
    }

    public void setUserLocale(String loc) {
        BaseLoginAction.setUserLocale(loc, this.session);
    }

    public void setUserGroups(List groups) {
        BaseLoginAction.setUserGroups(groups, this.session);
    }

    @Override
    public void setSessionGroup(String group) {
        BaseLoginAction.setUserGroups(this.session, group);
    }

    public static void setUserGroups(List groups, Context session) {
        if (!session.hasAttribute(USER_KEY)) {
            throw new IllegalStateException("Tried to set user groups, but there is no user in the session!");
        }
        ArrayList<String> list = new ArrayList<String>(groups.size());
        if (groups != null && groups.size() > 0) {
            for (int i = 0; i < groups.size(); ++i) {
                Group g;
                if (groups.get(i) instanceof String) {
                    String s = (String)groups.get(i);
                    list.add(s);
                    continue;
                }
                if (groups.get(i) instanceof Group) {
                    list.add((String)groups.get(i));
                    continue;
                }
                if (!(groups.get(i) instanceof Integer) || (g = AuthorizationManager.getGroup((Integer)groups.get(i))) == null) continue;
                list.add(g.getName());
            }
        }
        session.setAttribute(GROUPS_KEY, list);
    }

    public void setUserGroup(String group) {
        BaseLoginAction.setUserGroup(group, this.session);
    }

    public static void setUserGroup(String group, Context session) {
        if (!session.hasAttribute(USER_KEY)) {
            throw new IllegalStateException("Tried to set user groups, but there is no user in the session!");
        }
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(group);
        session.setAttribute(GROUPS_KEY, list);
    }

    @Override
    public boolean bypassAuthentication(String innerAction) {
        return true;
    }

    public void setUserGroup(Group group) {
        BaseLoginAction.setUserGroup(group, this.session);
    }

    public static void setUserGroup(Group group, Context session) {
        if (!session.hasAttribute(USER_KEY)) {
            throw new IllegalStateException("Tried to set user groups, but there is no user in the session!");
        }
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(group.getName());
        session.setAttribute(GROUPS_KEY, list);
    }

    public static void setUserGroup(int groupId, Context session) {
        Group g = AuthorizationManager.getGroup(groupId);
        if (g != null) {
            BaseLoginAction.setUserGroup(g, session);
        }
    }

    public void setUserGroups(String groups) {
        BaseLoginAction.setUserGroups(groups, this.session);
    }

    public static void setUserGroups(String groups, Context session) {
        if (!session.hasAttribute(USER_KEY)) {
            throw new IllegalStateException("Tried to set user groups, but there is no user in the session!");
        }
        StringTokenizer st = new StringTokenizer(groups, ",");
        ArrayList<String> list = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        session.setAttribute(GROUPS_KEY, list);
    }

    public void setUserGroups(String ... groups) {
        BaseLoginAction.setUserGroups(this.session, groups);
    }

    public static void setUserGroups(Context session, String ... groups) {
        if (!session.hasAttribute(USER_KEY)) {
            throw new IllegalStateException("Tried to set user groups, but there is no user in the session!");
        }
        ArrayList<String> list = new ArrayList<String>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            list.add(groups[i]);
        }
        session.setAttribute(GROUPS_KEY, list);
    }

    public void setUserGroups(Group ... groups) {
        BaseLoginAction.setUserGroups(this.session, groups);
    }

    public static void setUserGroups(Context session, Group ... groups) {
        if (!session.hasAttribute(USER_KEY)) {
            throw new IllegalStateException("Tried to set user groups, but there is no user in the session!");
        }
        ArrayList<Group> list = new ArrayList<Group>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            list.add(groups[i]);
        }
        session.setAttribute(GROUPS_KEY, list);
    }

    @Override
    public boolean isLogged() {
        return BaseLoginAction.isLogged(this.session);
    }

    public Object getUserSession() {
        return BaseLoginAction.getUserSession(this.session);
    }

    @Override
    public Locale getUserLocale() {
        return BaseLoginAction.getUserLocale(this.session);
    }

    public List<Object> getUserGroups() {
        return BaseLoginAction.getUserGroups(this.session);
    }

    public static boolean isLogged(Context session) {
        return session.hasAttribute(USER_KEY);
    }

    public static boolean isLogged(HttpSession session) {
        return session.getAttribute(USER_KEY) != null;
    }

    public static Object getUserSession(Context session) {
        return session.getAttribute(USER_KEY);
    }

    public static Object getSessionObj(Context session) {
        return session.getAttribute(USER_KEY);
    }

    public static Object getSessionObj(HttpSession session) {
        return session.getAttribute(USER_KEY);
    }

    public Object getSessionObj() {
        return BaseLoginAction.getSessionObj(this.session);
    }

    public static Object getUserSession(Map<String, Object> session) {
        return session.get(USER_KEY);
    }

    public static Object getUserSession(HttpSession session) {
        return session.getAttribute(USER_KEY);
    }

    public static Locale getUserLocale(Context session) {
        return (Locale)session.getAttribute(LOCALE_KEY);
    }

    public static Locale getUserLocale(HttpSession session) {
        return (Locale)session.getAttribute(LOCALE_KEY);
    }

    public static List<Object> getUserGroups(Context session) {
        return (List)session.getAttribute(GROUPS_KEY);
    }

    public static List<Object> getUserGroups(HttpSession session) {
        return (List)session.getAttribute(GROUPS_KEY);
    }
}

