/*
 * Decompiled with CFR 0.152.
 */
package org.mentaregex;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regex {
    private static final String TOKEN1 = "A1cxxZ";
    private static final String TOKEN2 = "Bbsd423xx12asdf44xT";
    private static final char DEFAULT_ESCAPE_CHAR = '\\';
    private final String s;
    private final String escPattern;
    private final boolean caseInsensitive;
    private final boolean global;
    private final boolean substitute;
    private final String toSub;

    public Regex(String s, String pattern, char escape) {
        this.s = s;
        this.substitute = pattern.startsWith("s/");
        this.global = pattern.endsWith("/gi") || pattern.endsWith("/ig") || pattern.endsWith("/g");
        this.caseInsensitive = pattern.endsWith("/gi") || pattern.endsWith("/ig") || pattern.endsWith("/i");
        pattern = Regex.removeSlashes(pattern);
        if (!this.substitute) {
            this.escPattern = escape != '\\' ? Regex.changeEscapeChar(pattern, escape) : pattern;
            this.toSub = null;
        } else {
            String[] parts;
            String token = null;
            if (!pattern.contains(TOKEN1)) {
                token = TOKEN1;
            } else if (!pattern.contains(TOKEN2)) {
                token = TOKEN2;
            } else {
                throw new RuntimeException("Cannot use mentawai Regex with this pattern!");
            }
            String newPattern = pattern.replaceAll("\\" + escape + "/", token);
            boolean changed = false;
            if (!newPattern.equals(pattern)) {
                pattern = newPattern;
                changed = true;
            }
            if ((parts = pattern.split("/")).length == 1 && pattern.endsWith("/")) {
                String save = parts[0];
                parts = new String[]{save, ""};
            } else if (parts.length != 2) {
                throw new IllegalArgumentException("Bad substitute pattern: " + pattern);
            }
            this.toSub = changed ? parts[1].replaceAll(token, "/") : parts[1];
            this.escPattern = escape != '\\' ? (changed ? Regex.changeEscapeChar(parts[0], escape).replaceAll(token, "\\/") : Regex.changeEscapeChar(parts[0], escape)) : (changed ? parts[0].replaceAll(token, "\\/") : parts[0]);
        }
    }

    public Regex(String s, String pattern) {
        this(s, pattern, '\\');
    }

    private static String removeSlashes(String s) {
        if (s.startsWith("s/")) {
            s = s.substring(2, s.length());
        } else if (s.startsWith("/")) {
            s = s.substring(1, s.length());
        }
        if (s.endsWith("/gi") || s.endsWith("/ig")) {
            s = s.substring(0, s.length() - 3);
        } else if (s.endsWith("/g") || s.endsWith("/i")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static String changeEscapeChar(String s, char esc) {
        return s.replace(esc, '\\');
    }

    public String substitute() {
        Pattern p = null;
        p = this.caseInsensitive ? Pattern.compile(this.escPattern, 2) : Pattern.compile(this.escPattern);
        Matcher m = p.matcher(this.s);
        if (this.global) {
            return m.replaceAll(this.toSub);
        }
        return m.replaceFirst(this.toSub);
    }

    public boolean matches() {
        Pattern p = null;
        p = this.caseInsensitive ? Pattern.compile(this.escPattern, 2) : Pattern.compile(this.escPattern);
        Matcher m = p.matcher(this.s);
        return m.find();
    }

    public String[] match() {
        Pattern p = null;
        p = this.caseInsensitive ? Pattern.compile(this.escPattern, 2) : Pattern.compile(this.escPattern);
        Matcher m = p.matcher(this.s);
        LinkedList<String> res = new LinkedList<String>();
        while (m.find()) {
            int x = m.groupCount();
            for (int i = 0; i < x; ++i) {
                res.add(m.group(i + 1));
            }
            if (this.global) continue;
            break;
        }
        if (res.size() == 0) {
            return null;
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] match(String s, String pattern) {
        return Regex.match(s, pattern, '\\');
    }

    public static boolean matches(String s, String pattern) {
        return Regex.matches(s, pattern, '\\');
    }

    public static String[] match(String s, String pattern, char escapeChar) {
        Regex r = new Regex(s, pattern, escapeChar);
        return r.match();
    }

    public static boolean matches(String s, String pattern, char escapeChar) {
        Regex r = new Regex(s, pattern, escapeChar);
        return r.matches();
    }

    public static String sub(String s, String pattern) {
        return Regex.sub(s, pattern, '\\');
    }

    public static String sub(String s, String pattern, char escapeChar) {
        Regex r = new Regex(s, pattern, escapeChar);
        return r.substitute();
    }

    public static String escapeSlash(String s, String escapeChar) {
        return s.replaceAll("/", escapeChar + "/");
    }
}

