/*
 * Decompiled with CFR 0.152.
 */
package org.mentacontainer.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.mentacontainer.util.InjectionUtils;

class SetterDependency {
    private final String targetProperty;
    private final String sourceFromContainer;
    private final Class<? extends Object> sourceType;
    private Map<String, Method> cache = new HashMap<String, Method>();

    public SetterDependency(String targetProperty, String sourceFromContainer, Class<? extends Object> sourceType) {
        this.targetProperty = targetProperty;
        this.sourceFromContainer = sourceFromContainer;
        this.sourceType = sourceType;
    }

    public String getTarget() {
        return this.targetProperty;
    }

    public String getSource() {
        return this.sourceFromContainer;
    }

    public int hashCode() {
        return this.targetProperty.hashCode() * 31 + this.sourceFromContainer.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetterDependency)) {
            return false;
        }
        SetterDependency d = (SetterDependency)obj;
        if (!d.targetProperty.equals(this.targetProperty)) {
            return false;
        }
        return d.sourceFromContainer.equals(this.sourceFromContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method check(Class<? extends Object> targetClass) {
        String className = targetClass.getName();
        Method m = null;
        Map<String, Method> map = this.cache;
        synchronized (map) {
            m = this.cache.get(className);
        }
        if (m == null && this.cache.containsKey(className)) {
            return null;
        }
        if (m != null) {
            return m;
        }
        m = InjectionUtils.findMethodToInject(targetClass, this.targetProperty, this.sourceType);
        if (m != null) {
            map = this.cache;
            synchronized (map) {
                this.cache.put(className, m);
            }
            return m;
        }
        map = this.cache;
        synchronized (map) {
            this.cache.put(className, null);
        }
        return null;
    }
}

