/*
 * Decompiled with CFR 0.152.
 */
package org.mentacontainer.impl;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.mentacontainer.ConfigurableFactory;
import org.mentacontainer.Container;
import org.mentacontainer.Factory;
import org.mentacontainer.Interceptor;
import org.mentacontainer.Scope;
import org.mentacontainer.impl.ClassFactory;
import org.mentacontainer.impl.ConstructorDependency;
import org.mentacontainer.impl.SetterDependency;
import org.mentacontainer.util.InjectionUtils;

public class MentaContainer
implements Container {
    private Map<String, Factory> factoriesByName = new Hashtable<String, Factory>();
    private Map<String, Scope> scopes = new Hashtable<String, Scope>();
    private Map<String, Object> singletonsCache = new Hashtable<String, Object>();
    private Map<String, ThreadLocal<Object>> threadLocalsCache = new Hashtable<String, ThreadLocal<Object>>();
    private Set<SetterDependency> setterDependencies = Collections.synchronizedSet(new HashSet());
    private Set<ConstructorDependency> constructorDependencies = Collections.synchronizedSet(new HashSet());
    private Set<ConstructorDependency> forConstructMethod = Collections.synchronizedSet(new HashSet());

    @Override
    public Class<? extends Object> getType(String key) {
        Factory factory = this.factoriesByName.get(key);
        if (factory == null) {
            return null;
        }
        return factory.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(Scope scope) {
        block12: {
            block11: {
                if (scope != Scope.SINGLETON) break block11;
                LinkedList<ClearableHolder> listToClear = new LinkedList<ClearableHolder>();
                MentaContainer mentaContainer = this;
                synchronized (mentaContainer) {
                    for (String string : this.singletonsCache.keySet()) {
                        Factory factory = this.factoriesByName.get(string);
                        if (!(factory instanceof Interceptor)) continue;
                        Interceptor c = (Interceptor)((Object)factory);
                        Object value = this.singletonsCache.get(string);
                        listToClear.add(new ClearableHolder(c, value));
                    }
                    this.singletonsCache.clear();
                }
                for (ClearableHolder cp : listToClear) {
                    cp.clear();
                }
                break block12;
            }
            if (scope != Scope.THREAD) break block12;
            LinkedList<ClearableHolder> listToClear = new LinkedList<ClearableHolder>();
            MentaContainer i$ = this;
            synchronized (i$) {
                for (String string : this.threadLocalsCache.keySet()) {
                    Factory factory = this.factoriesByName.get(string);
                    if (!(factory instanceof Interceptor)) continue;
                    Interceptor c = (Interceptor)((Object)factory);
                    ThreadLocal<Object> t = this.threadLocalsCache.get(string);
                    Object value = t.get();
                    if (value == null) continue;
                    listToClear.add(new ClearableHolder(c, value));
                }
                for (ThreadLocal threadLocal : this.threadLocalsCache.values()) {
                    threadLocal.set(null);
                }
            }
            for (ClearableHolder cp : listToClear) {
                cp.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T clear(String key) {
        if (!this.factoriesByName.containsKey(key)) {
            return null;
        }
        Scope scope = this.scopes.get(key);
        if (scope == Scope.SINGLETON) {
            ClearableHolder cp = null;
            Object value = null;
            MentaContainer mentaContainer = this;
            synchronized (mentaContainer) {
                Factory factory;
                value = this.singletonsCache.remove(key);
                if (value != null && (factory = this.factoriesByName.get(key)) instanceof Interceptor) {
                    Interceptor c = (Interceptor)((Object)factory);
                    cp = new ClearableHolder(c, value);
                }
            }
            if (cp != null) {
                cp.c.onCleared(cp.value);
            }
            return (T)value;
        }
        if (scope == Scope.THREAD) {
            ClearableHolder cp = null;
            Object retVal = null;
            MentaContainer mentaContainer = this;
            synchronized (mentaContainer) {
                Object o;
                ThreadLocal<Object> t = this.threadLocalsCache.get(key);
                if (t != null && (o = t.get()) != null) {
                    Factory factory = this.factoriesByName.get(key);
                    if (factory instanceof Interceptor) {
                        Interceptor c = (Interceptor)((Object)factory);
                        cp = new ClearableHolder(c, o);
                    }
                    t.set(null);
                    retVal = o;
                }
            }
            if (cp != null) {
                cp.c.onCleared(cp.value);
            }
            return (T)retVal;
        }
        if (scope == Scope.NONE) {
            return null;
        }
        throw new UnsupportedOperationException("Scope not supported: " + (Object)((Object)scope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public <T> T get(String key) {
        if (!this.factoriesByName.containsKey(key)) {
            return null;
        }
        Factory c = this.factoriesByName.get(key);
        Scope scope = this.scopes.get(key);
        Object target = null;
        try {
            boolean needsToCreate;
            if (scope == Scope.SINGLETON) {
                needsToCreate = false;
                MentaContainer mentaContainer = this;
                // MONITORENTER : mentaContainer
                if (this.singletonsCache.containsKey(key)) {
                    target = this.singletonsCache.get(key);
                    // MONITOREXIT : mentaContainer
                    return (T)target;
                }
                needsToCreate = true;
                // MONITOREXIT : mentaContainer
                if (needsToCreate) {
                    target = c.getInstance();
                    this.checkInterceptable(c, target);
                    mentaContainer = this;
                    // MONITORENTER : mentaContainer
                    this.singletonsCache.put(key, target);
                    // MONITOREXIT : mentaContainer
                }
            } else if (scope == Scope.THREAD) {
                needsToCreate = false;
                boolean needsToAddToCache = false;
                ThreadLocal<Object> t = null;
                MentaContainer mentaContainer = this;
                // MONITORENTER : mentaContainer
                if (this.threadLocalsCache.containsKey(key)) {
                    t = this.threadLocalsCache.get(key);
                    target = t.get();
                    if (target != null) {
                        // MONITOREXIT : mentaContainer
                        return (T)target;
                    }
                    needsToCreate = true;
                } else {
                    t = new ThreadLocal();
                    needsToCreate = true;
                    needsToAddToCache = true;
                }
                // MONITOREXIT : mentaContainer
                if (needsToCreate) {
                    target = c.getInstance();
                    this.checkInterceptable(c, target);
                    t.set(target);
                }
                if (needsToAddToCache) {
                    mentaContainer = this;
                    // MONITORENTER : mentaContainer
                    this.threadLocalsCache.put(key, t);
                    // MONITOREXIT : mentaContainer
                }
            } else {
                if (scope != Scope.NONE) throw new UnsupportedOperationException("Don't know how to handle scope: " + (Object)((Object)scope));
                target = c.getInstance();
                this.checkInterceptable(c, target);
            }
            if (target == null) return (T)target;
            Iterator<SetterDependency> i$ = this.setterDependencies.iterator();
            while (i$.hasNext()) {
                String sourceKey;
                SetterDependency d = i$.next();
                Method m = d.check(target.getClass());
                if (m == null || (sourceKey = d.getSource()).equals(key)) continue;
                T source = this.get(sourceKey);
                try {
                    m.invoke(target, source);
                }
                catch (Exception e) {
                    Object object;
                    StringBuilder stringBuilder = new StringBuilder().append("Cannot inject dependency: method = ").append(m != null ? m.getName() : "NULL").append(" / source = ");
                    if (source != null) {
                        object = source;
                        throw new RuntimeException(stringBuilder.append(object).append(" / target = ").append(target).toString(), e);
                    }
                    object = "NULL";
                    throw new RuntimeException(stringBuilder.append(object).append(" / target = ").append(target).toString(), e);
                }
            }
            return (T)target;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final void checkInterceptable(Factory f, Object value) {
        if (f instanceof Interceptor) {
            Interceptor i = (Interceptor)((Object)f);
            ((Interceptor)((Object)f)).onCreated(value);
        }
    }

    @Override
    public Factory ioc(String key, Factory factory, Scope scope) {
        this.factoriesByName.put(key, factory);
        this.singletonsCache.remove(key);
        this.threadLocalsCache.remove(key);
        this.scopes.put(key, scope);
        this.forConstructMethod.add(new ConstructorDependency(key, factory.getType()));
        return factory;
    }

    @Override
    public Factory ioc(String key, Factory factory) {
        return this.ioc(key, factory, Scope.NONE);
    }

    @Override
    public ConfigurableFactory ioc(String key, Class<? extends Object> klass) {
        ClassFactory cc = new ClassFactory(this, klass);
        this.ioc(key, cc);
        return cc;
    }

    @Override
    public ConfigurableFactory ioc(String key, Class<? extends Object> klass, Scope scope) {
        ClassFactory cc = new ClassFactory(this, klass);
        this.ioc(key, cc, scope);
        return cc;
    }

    @Override
    public void autowire(String sourceFromContainer) {
        this.autowireBySetter(sourceFromContainer);
        this.autowireByConstructor(sourceFromContainer);
    }

    @Override
    public void autowire(String sourceFromContainer, String beanProperty) {
        this.autowireBySetter(beanProperty, sourceFromContainer);
    }

    private void autowireBySetter(String targetProperty, String sourceFromContainer) {
        Class<? extends Object> sourceType = this.getType(sourceFromContainer);
        SetterDependency d = new SetterDependency(targetProperty, sourceFromContainer, sourceType);
        this.setterDependencies.add(d);
    }

    private void autowireBySetter(String targetProperty) {
        this.autowireBySetter(targetProperty, targetProperty);
    }

    private void autowireByConstructor(String sourceFromContainer) {
        Class<? extends Object> sourceType = this.getType(sourceFromContainer);
        ConstructorDependency d = new ConstructorDependency(sourceFromContainer, sourceType);
        this.constructorDependencies.add(d);
    }

    Set<ConstructorDependency> getConstructorDependencies() {
        return this.constructorDependencies;
    }

    @Override
    public <T> T construct(Class<? extends Object> klass) {
        ClassFactory f = new ClassFactory(this, klass, this.forConstructMethod);
        return f.getInstance();
    }

    @Override
    public void inject(Object bean) {
        InjectionUtils.Provider p = new InjectionUtils.Provider(){

            @Override
            public Object get(String key) {
                return MentaContainer.this.get(key);
            }

            @Override
            public boolean hasValue(String key) {
                return MentaContainer.this.check(key);
            }
        };
        try {
            InjectionUtils.getObject(bean, p, false, null, true, false, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error populating bean: " + bean, e);
        }
    }

    @Override
    public synchronized boolean check(String key) {
        if (!this.factoriesByName.containsKey(key)) {
            return false;
        }
        Scope scope = this.scopes.get(key);
        if (scope == Scope.NONE) {
            return false;
        }
        if (scope == Scope.SINGLETON) {
            return this.singletonsCache.containsKey(key);
        }
        if (scope == Scope.THREAD) {
            ThreadLocal<Object> t = this.threadLocalsCache.get(key);
            if (t != null) {
                return t.get() != null;
            }
            return false;
        }
        throw new UnsupportedOperationException("This scope is not supported: " + (Object)((Object)scope));
    }

    private static class ClearableHolder {
        private Interceptor c;
        private Object value;

        public ClearableHolder(Interceptor c, Object value) {
            this.c = c;
            this.value = value;
        }

        public void clear() {
            this.c.onCleared(this.value);
        }
    }
}

