/*
 * Decompiled with CFR 0.152.
 */
package org.mentacontainer.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mentacontainer.ConfigurableFactory;
import org.mentacontainer.impl.ConstructorDependency;
import org.mentacontainer.impl.MentaContainer;
import org.mentacontainer.util.FindConstructor;
import org.mentacontainer.util.FindMethod;

class ClassFactory
implements ConfigurableFactory {
    private final MentaContainer container;
    private final Class<? extends Object> klass;
    private Map<String, Object> props = null;
    private List<Object> initValues = null;
    private List<Class<? extends Object>> initTypes = null;
    private Constructor<? extends Object> constructor = null;
    private Map<String, Method> cache = null;
    private boolean useZeroArgumentsConstructor = false;
    private final Set<ConstructorDependency> constructorDependencies;

    public ClassFactory(MentaContainer container, Class<? extends Object> klass) {
        this(container, klass, null);
    }

    ClassFactory(MentaContainer container, Class<? extends Object> klass, Set<ConstructorDependency> constructorDependencies) {
        this.container = container;
        this.klass = klass;
        this.constructorDependencies = constructorDependencies;
    }

    @Override
    public ConfigurableFactory addPropertyValue(String name, Object value) {
        if (this.props == null) {
            this.props = new HashMap<String, Object>();
            this.cache = new HashMap<String, Method>();
        }
        this.props.put(name, value);
        return this;
    }

    @Override
    public ConfigurableFactory useZeroArgumentConstructor() {
        this.useZeroArgumentsConstructor = true;
        return this;
    }

    @Override
    public ConfigurableFactory addPropertyDependency(String property, String key) {
        return this.addPropertyValue(property, new DependencyKey(key));
    }

    @Override
    public ConfigurableFactory addPropertyDependency(String property) {
        return this.addPropertyDependency(property, property);
    }

    @Override
    public ConfigurableFactory addInitDependency(String key) {
        return this.addInitValue(new DependencyKey(key), this.container.getType(key));
    }

    private ConfigurableFactory addInitValue(Object value, Class<? extends Object> type) {
        if (this.initValues == null) {
            this.initValues = new LinkedList<Object>();
            this.initTypes = new LinkedList<Class<? extends Object>>();
        }
        this.initValues.add(value);
        this.initTypes.add(type);
        return this;
    }

    @Override
    public ConfigurableFactory addInitValue(Object value) {
        return this.addInitValue(value, value.getClass());
    }

    @Override
    public ConfigurableFactory addInitPrimitive(Object value) {
        Class<? extends Object> primitive = ClassFactory.getPrimitiveFrom(value);
        if (primitive == null) {
            throw new IllegalArgumentException("Value is not a primitive: " + value);
        }
        return this.addInitValue(value, primitive);
    }

    private List<Class<? extends Object>> convertToPrimitives(List<Class<? extends Object>> list) {
        if (list == null) {
            return null;
        }
        Iterator<Class<? extends Object>> iter = list.iterator();
        LinkedList<Class<? extends Object>> results = new LinkedList<Class<? extends Object>>();
        while (iter.hasNext()) {
            Class<? extends Object> klass = iter.next();
            Class<? extends Object> primitive = ClassFactory.getPrimitiveFrom(klass);
            if (primitive != null) {
                results.add(primitive);
                continue;
            }
            results.add(klass);
        }
        return results;
    }

    private Class<? extends Object>[] getClasses(List<Class<? extends Object>> values) {
        if (values == null) {
            return new Class[0];
        }
        Class[] types = new Class[values.size()];
        return values.toArray(types);
    }

    private Object[] getValues(List<Object> values) throws InstantiationException {
        if (values == null) {
            return null;
        }
        Object[] array = new Object[values.size()];
        int index = 0;
        for (Object obj : values) {
            if (obj instanceof DependencyKey) {
                DependencyKey dk = (DependencyKey)obj;
                array[index++] = this.container.get(dk.getKey());
                continue;
            }
            array[index++] = obj;
        }
        return array;
    }

    private void setValue(Object bean, String name, Object value) {
        try {
            Method m;
            StringBuffer sb = new StringBuffer(30);
            sb.append("set");
            sb.append(name.substring(0, 1).toUpperCase());
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            String methodName = sb.toString();
            if (!this.cache.containsKey(name)) {
                block11: {
                    m = null;
                    try {
                        m = FindMethod.getMethod(this.klass, methodName, new Class[]{value.getClass()});
                    }
                    catch (Exception e) {
                        Class<? extends Object> primitive = ClassFactory.getPrimitiveFrom(value);
                        if (primitive != null) {
                            try {
                                m = this.klass.getMethod(methodName, primitive);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (m != null) break block11;
                        throw new InstantiationException("Cannot find method for property: " + name);
                    }
                }
                if (m != null) {
                    this.cache.put(name, m);
                    m.setAccessible(true);
                }
            }
            if ((m = this.cache.get(name)) != null) {
                m.invoke(bean, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to set a property with reflection: " + name, e);
        }
    }

    private static Class<? extends Object> getPrimitiveFrom(Object w) {
        if (w instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (w instanceof Byte) {
            return Byte.TYPE;
        }
        if (w instanceof Short) {
            return Short.TYPE;
        }
        if (w instanceof Character) {
            return Character.TYPE;
        }
        if (w instanceof Integer) {
            return Integer.TYPE;
        }
        if (w instanceof Long) {
            return Long.TYPE;
        }
        if (w instanceof Float) {
            return Float.TYPE;
        }
        if (w instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    private static Class<? extends Object> getPrimitiveFrom(Class<? extends Object> klass) {
        if (klass.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (klass.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (klass.equals(Short.class)) {
            return Short.TYPE;
        }
        if (klass.equals(Character.class)) {
            return Character.TYPE;
        }
        if (klass.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (klass.equals(Long.class)) {
            return Long.TYPE;
        }
        if (klass.equals(Float.class)) {
            return Float.TYPE;
        }
        if (klass.equals(Double.class)) {
            return Double.TYPE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getInstance() {
        Object obj = null;
        Object[] values = null;
        ClassFactory classFactory = this;
        synchronized (classFactory) {
            if (this.constructor == null) {
                if (!this.useZeroArgumentsConstructor) {
                    this.checkConstructorDependencies();
                } else {
                    if (this.initTypes != null) {
                        this.initTypes = null;
                    }
                    if (this.initValues != null) {
                        this.initValues = null;
                    }
                }
                try {
                    this.constructor = FindConstructor.getConstructor(this.klass, this.getClasses(this.initTypes));
                }
                catch (Exception e) {
                    try {
                        this.constructor = FindConstructor.getConstructor(this.klass, this.getClasses(this.convertToPrimitives(this.initTypes)));
                    }
                    catch (Exception ee) {
                        throw new RuntimeException("Cannot find a constructor for class: " + this.klass);
                    }
                }
            }
            try {
                values = this.getValues(this.initValues);
            }
            catch (Exception e) {
                new RuntimeException("Cannot instantiate values for constructor!", e);
            }
        }
        try {
            obj = this.constructor.newInstance(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create instance from constructor: " + this.constructor, e);
        }
        if (this.props != null && this.props.size() > 0) {
            for (String name : this.props.keySet()) {
                Object value = this.props.get(name);
                if (value instanceof DependencyKey) {
                    DependencyKey dk = (DependencyKey)value;
                    value = this.container.get(dk.getKey());
                }
                this.setValue(obj, name, value);
            }
        }
        return (T)obj;
    }

    private static boolean betterIsAssignableFrom(Class<? extends Object> klass1, Class<? extends Object> klass2) {
        Class<? extends Object> k2;
        if (klass1.isAssignableFrom(klass2)) {
            return true;
        }
        Class<? extends Object> k1 = klass1.isPrimitive() ? klass1 : ClassFactory.getPrimitiveFrom(klass1);
        Class<? extends Object> clazz = k2 = klass2.isPrimitive() ? klass2 : ClassFactory.getPrimitiveFrom(klass2);
        if (k1 == null || k2 == null) {
            return false;
        }
        return k1.isAssignableFrom(k2);
    }

    private void checkConstructorDependencies() {
        Constructor<?>[] constructors;
        for (Constructor<?> c : constructors = this.klass.getConstructors()) {
            LinkedList<Object> providedInitTypes = null;
            providedInitTypes = this.initTypes != null ? new LinkedList<Class<? extends Object>>(this.initTypes) : new LinkedList();
            LinkedList<Object> providedInitValues = null;
            providedInitValues = this.initValues != null ? new LinkedList<Object>(this.initValues) : new LinkedList();
            LinkedList<Class<? extends Object>> newInitTypes = new LinkedList<Class<? extends Object>>();
            LinkedList<Object> newInitValues = new LinkedList<Object>();
            Set<ConstructorDependency> constructorDependencies = this.constructorDependencies != null ? this.constructorDependencies : this.container.getConstructorDependencies();
            HashSet<ConstructorDependency> dependencies = new HashSet<ConstructorDependency>(constructorDependencies);
            Class<?>[] constructorParams = c.getParameterTypes();
            if (constructorParams == null || constructorParams.length == 0) continue;
            for (Class<?> constructorParam : constructorParams) {
                Class provided;
                Class clazz = provided = providedInitTypes.isEmpty() ? null : (Class)providedInitTypes.get(0);
                if (provided != null && constructorParam.isAssignableFrom(provided)) {
                    newInitTypes.add((Class<? extends Object>)providedInitTypes.removeFirst());
                    newInitValues.add(providedInitValues.removeFirst());
                    continue;
                }
                Iterator iter = dependencies.iterator();
                boolean foundMatch = false;
                while (iter.hasNext()) {
                    ConstructorDependency d = (ConstructorDependency)iter.next();
                    if (!ClassFactory.betterIsAssignableFrom(constructorParam, d.getSourceType())) continue;
                    iter.remove();
                    newInitTypes.add(d.getSourceType());
                    newInitValues.add(new DependencyKey(d.getSource()));
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) break;
            }
            if (constructorParams.length != newInitTypes.size() || !providedInitTypes.isEmpty()) continue;
            this.initTypes = newInitTypes;
            this.initValues = newInitValues;
        }
    }

    @Override
    public Class<? extends Object> getType() {
        return this.klass;
    }

    private static class DependencyKey {
        private String key;

        public DependencyKey(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }
}

