/*
 * Decompiled with CFR 0.152.
 */
package org.mentacontainer.example;

import java.util.Date;
import org.mentacontainer.Scope;
import org.mentacontainer.impl.MentaContainer;

public class BasicOperations {
    public static void main(String[] args) {
        BasicOperations.case1();
        BasicOperations.case2();
        BasicOperations.case3();
        BasicOperations.case4();
        BasicOperations.case5();
        BasicOperations.case6();
        BasicOperations.case7();
        BasicOperations.case8();
        BasicOperations.case9();
        BasicOperations.case10();
    }

    private static void case9() {
        MentaContainer c = new MentaContainer();
        c.ioc("connection", Connection.class);
        c.ioc("accountDAO", JdbcAccountDAO.class);
        c.ioc("userDAO", JdbcUserDAO.class);
        c.autowire("connection");
        AccountDAO accountDAO = (AccountDAO)c.get("accountDAO");
        UserDAO userDAO = (UserDAO)c.get("userDAO");
        System.out.println(accountDAO.getBalance(25));
        System.out.println(userDAO.getUsername(45));
    }

    private static void case1() {
        MentaContainer c = new MentaContainer();
        c.ioc("myString1", String.class);
        String myString1 = (String)c.get("myString1");
        System.out.println(myString1);
        c.ioc("myString2", String.class).addInitValue("saoj");
        String myString2 = (String)c.get("myString2");
        System.out.println(myString2);
        c.ioc("myDate1", Date.class).addPropertyValue("hours", 15).addPropertyValue("minutes", 10).addPropertyValue("seconds", 45);
        Date myDate1 = (Date)c.get("myDate1");
        System.out.println(myDate1);
    }

    private static void case5() {
        MentaContainer c = new MentaContainer();
        c.ioc("connection", Connection.class);
        c.ioc("accountDAO", JdbcAccountDAO.class).addInitDependency("connection");
        AccountDAO accountDAO = (AccountDAO)c.get("accountDAO");
        System.out.println(accountDAO.getBalance(25));
    }

    private static void case7() {
        MentaContainer c = new MentaContainer();
        c.ioc("connection", Connection.class);
        c.ioc("accountDAO", JdbcAccountDAO.class);
        c.autowire("connection");
        AccountDAO accountDAO = (AccountDAO)c.get("accountDAO");
        System.out.println(accountDAO.getBalance(25));
    }

    private static void case6() {
        MentaContainer c = new MentaContainer();
        c.ioc("connection", Connection.class);
        c.ioc("userDAO", JdbcUserDAO.class).addPropertyDependency("connection");
        UserDAO userDAO = (UserDAO)c.get("userDAO");
        System.out.println(userDAO.getUsername(54));
    }

    private static void case8() {
        MentaContainer c = new MentaContainer();
        c.ioc("connection", Connection.class);
        c.ioc("userDAO", JdbcUserDAO.class);
        c.autowire("connection");
        UserDAO userDAO = (UserDAO)c.get("userDAO");
        System.out.println(userDAO.getUsername(54));
    }

    private static void case2() {
        MentaContainer c = new MentaContainer();
        c.ioc("myString", String.class, Scope.SINGLETON).addInitValue("saoj");
        String s1 = (String)c.get("myString");
        String s2 = (String)c.get("myString");
        System.out.println(s1 == s2);
        System.out.println(s1.equals(s2));
    }

    private static void case3() {
        MentaContainer c = new MentaContainer();
        c.ioc("userDAO", JdbcUserDAO.class);
        c.ioc("connection", Connection.class);
        c.autowire("connection");
        UserDAO userDAO = (UserDAO)c.get("userDAO");
        System.out.println(userDAO.getUsername(11));
    }

    private static void case4() {
        MentaContainer c = new MentaContainer();
        c.ioc("userDAO", JdbcUserDAO.class);
        c.ioc("connection", Connection.class);
        c.autowire("connection");
        SomeService service = new SomeService();
        c.inject(service);
        service.doSomething();
    }

    private static void case10() {
        MentaContainer c = new MentaContainer();
        c.ioc("userDAO", JdbcUserDAO.class);
        c.ioc("connection", Connection.class);
        c.autowire("connection");
        SomeService2 service = (SomeService2)c.construct(SomeService2.class);
        service.doSomething();
    }

    public static class SomeService2 {
        private final UserDAO userDAO;

        public SomeService2(UserDAO userDAO) {
            this.userDAO = userDAO;
        }

        public void doSomething() {
            System.out.println(this.userDAO.getUsername(11));
        }
    }

    public static class SomeService {
        private UserDAO userDAO;

        public void setUserDAO(UserDAO userDAO) {
            this.userDAO = userDAO;
        }

        public void doSomething() {
            System.out.println(this.userDAO.getUsername(11));
        }
    }

    public static class JdbcAccountDAO
    implements AccountDAO {
        private final Connection conn;

        public JdbcAccountDAO(Connection conn) {
            this.conn = conn;
        }

        @Override
        public double getBalance(int id) {
            assert (this.conn != null);
            return 1000000.0;
        }
    }

    public static interface AccountDAO {
        public double getBalance(int var1);
    }

    public static class JdbcUserDAO
    implements UserDAO {
        private Connection conn;

        public void setConnection(Connection conn) {
            this.conn = conn;
        }

        @Override
        public String getUsername(int id) {
            if (this.conn == null) {
                throw new IllegalStateException("conn is null!");
            }
            return "saoj";
        }
    }

    public static interface UserDAO {
        public String getUsername(int var1);
    }

    public static class Connection {
    }
}

