/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;

public class EnumValueType
implements DBType<Enum<?>> {
    private final Class<? extends Enum<?>> enumType;

    public EnumValueType(Class<? extends Enum<?>> enumType) {
        this.enumType = enumType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.enumType.getSimpleName();
    }

    @Override
    public Enum<?> getFromResultSet(ResultSet rset, int index) throws SQLException {
        String s = rset.getString(index);
        if (s == null) {
            return null;
        }
        return Enum.valueOf(this.enumType, s);
    }

    @Override
    public Enum<?> getFromResultSet(ResultSet rset, String field) throws SQLException {
        String s = rset.getString(field);
        if (s == null) {
            return null;
        }
        return Enum.valueOf(this.enumType, s);
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return this.enumType;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Enum<?> value) throws SQLException {
        if (value == null) {
            stmt.setString(index, null);
        } else if (value.getClass().isAssignableFrom(this.enumType)) {
            String s = value.toString();
            stmt.setString(index, s);
        } else {
            throw new IllegalArgumentException("Value is not an enum!");
        }
    }
}

