/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean;

import org.mentabean.DBType;
import org.mentabean.type.TimestampType;

public class DBField {
    private final String name;
    private final DBType<?> type;
    private final String dbName;
    private final boolean isPK;
    private boolean defaultToNow = false;

    public DBField(String name, String dbName, DBType<?> type, boolean isPK) {
        this.name = name;
        this.dbName = dbName;
        this.type = type;
        this.isPK = isPK;
    }

    public void setDefaultToNow(boolean b) {
        if (!(this.getType() instanceof TimestampType)) {
            throw new IllegalStateException("Only TimestampType can be set to now!");
        }
        this.defaultToNow = b;
    }

    public boolean isDefaultToNow() {
        return this.defaultToNow;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("DBField: ").append(this.name).append(" type=").append(this.type).append(" dbName=").append(this.dbName);
        return sb.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBField) {
            DBField f = (DBField)obj;
            if (f.name.equalsIgnoreCase(this.name)) {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public DBType getType() {
        return this.type;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean isPK() {
        return this.isPK;
    }
}

