/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.wait;

import java.util.concurrent.locks.LockSupport;
import org.mentaqueue.wait.WaitStrategy;

public class SpinParkWaitStrategy
implements WaitStrategy {
    private static final int DEFAULT_SPIN_COUNT = 10000;
    private static final boolean DEFAULT_BACK_OFF = false;
    private final int spinCount;
    private final boolean parkBackOff;
    private int count = 0;
    private int sleepTime = 0;

    public SpinParkWaitStrategy(int spinCount, boolean parkBackOff) {
        this.spinCount = spinCount;
        this.parkBackOff = parkBackOff;
    }

    public SpinParkWaitStrategy(boolean parkBackOff) {
        this(10000, parkBackOff);
    }

    public SpinParkWaitStrategy(int spinCount) {
        this(spinCount, false);
    }

    public SpinParkWaitStrategy() {
        this(10000, false);
    }

    @Override
    public final void waitForOtherThread() {
        if (this.count < this.spinCount) {
            ++this.count;
        } else if (this.parkBackOff) {
            LockSupport.parkNanos(++this.sleepTime);
        } else {
            LockSupport.parkNanos(1L);
        }
    }

    @Override
    public final void reset() {
        this.count = 0;
        this.sleepTime = 0;
    }
}

