/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.sample;

import org.mentaqueue.AtomicQueue;
import org.mentaqueue.wait.SpinYieldParkWaitStrategy;
import org.mentaqueue.wait.YieldParkWaitStrategy;

public class SampleCodeWithWaitStrategy {
    private static int MESSAGES = 10000000;

    public static void main(String[] args) throws Exception {
        final SpinYieldParkWaitStrategy consumerWaitStrategy = new SpinYieldParkWaitStrategy(50, 50, true);
        YieldParkWaitStrategy producerWaitStrategy = new YieldParkWaitStrategy(10, true);
        final AtomicQueue<Entry> queue = new AtomicQueue<Entry>(8192, Entry.class);
        Thread t = new Thread(){

            @Override
            public void run() {
                boolean running = true;
                long expectedSequence = 1L;
                while (running) {
                    long x = queue.availableToPoll();
                    if (x > 0L) {
                        int i = 0;
                        while ((long)i < x) {
                            Entry entry = (Entry)queue.poll();
                            if (entry.sequence == expectedSequence) {
                                if (entry.sequence == (long)MESSAGES) {
                                    running = false;
                                } else {
                                    ++expectedSequence;
                                }
                            } else {
                                throw new IllegalStateException("This should NEVER happen!");
                            }
                            ++i;
                        }
                        queue.donePolling(true);
                        consumerWaitStrategy.reset();
                        continue;
                    }
                    consumerWaitStrategy.waitForOtherThread();
                }
            }
        };
        long start = System.currentTimeMillis();
        t.start();
        for (int i = 1; i <= MESSAGES; ++i) {
            Entry entry = (Entry)queue.nextToDispatch();
            if (entry == null) {
                producerWaitStrategy.waitForOtherThread();
                --i;
                continue;
            }
            entry.sequence = i;
            entry.message.append("message_").append(entry.sequence);
            queue.flush(true);
            producerWaitStrategy.reset();
        }
        t.join();
        long time = System.currentTimeMillis() - start;
        System.out.println("DONE in " + time + " millis");
    }

    public static class Entry {
        long sequence;
        StringBuilder message = new StringBuilder(256);
    }
}

