/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.pooled;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class PooledConcurrentLinkedQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final ConcurrentLinkedQueue<E> pool;
    private final ConcurrentLinkedQueue<E> queue;
    private final Builder<E> builder;
    private E returnedElem = null;
    private final E[] temp = new Object[16416];
    private int tempPointer = 0;

    public PooledConcurrentLinkedQueue(int capacity, Builder<E> builder) {
        this.pool = new ConcurrentLinkedQueue();
        this.queue = new ConcurrentLinkedQueue();
        this.builder = builder;
        for (int i = 0; i < capacity; ++i) {
            this.pool.offer(builder.newInstance());
        }
    }

    public PooledConcurrentLinkedQueue(Builder<E> builder) {
        this(16416, builder);
    }

    public PooledConcurrentLinkedQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public PooledConcurrentLinkedQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    @Override
    public E nextToDispatch() {
        E e = this.pool.poll();
        if (e == null) {
            e = this.builder.newInstance();
        }
        this.temp[this.tempPointer++] = e;
        return e;
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    @Override
    public void flush(boolean lazySet) {
        for (int i = 0; i < this.tempPointer; ++i) {
            this.queue.offer(this.temp[i]);
            this.temp[i] = null;
        }
        this.tempPointer = 0;
    }

    @Override
    public long availableToPoll() {
        E e = this.queue.peek();
        return e != null ? 1L : 0L;
    }

    @Override
    public E poll() {
        this.returnedElem = this.queue.poll();
        return this.returnedElem;
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public void donePolling(boolean lazySet) {
        this.pool.offer(this.returnedElem);
        this.returnedElem = null;
    }

    @Override
    public final void donePolling() {
        this.donePolling(false);
    }

    @Override
    public final void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void rollback(long count) {
        throw new UnsupportedOperationException();
    }
}

