/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.pooled;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class PooledBlockingLinkedQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final ConcurrentLinkedQueue<E> pool;
    private final List<E> polledElements;
    private final LinkedBlockingQueue<E> queue;
    private final Builder<E> builder;
    private final E[] temp = new Object[16416];
    private int tempPointer = 0;

    public PooledBlockingLinkedQueue(int capacity, Builder<E> builder) {
        this.pool = new ConcurrentLinkedQueue();
        this.polledElements = new LinkedList();
        this.queue = new LinkedBlockingQueue(capacity);
        this.builder = builder;
        for (int i = 0; i < capacity; ++i) {
            this.pool.offer(builder.newInstance());
        }
    }

    public PooledBlockingLinkedQueue(Builder<E> builder) {
        this(16416, builder);
    }

    public PooledBlockingLinkedQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public PooledBlockingLinkedQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    @Override
    public E nextToDispatch() {
        E e = this.pool.poll();
        if (e == null) {
            e = this.builder.newInstance();
        }
        this.temp[this.tempPointer++] = e;
        return e;
    }

    @Override
    public void flush(boolean lazySet) {
        try {
            for (int i = 0; i < this.tempPointer; ++i) {
                this.queue.put(this.temp[i]);
                this.temp[i] = null;
            }
            this.tempPointer = 0;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public long availableToPoll() {
        return this.queue.size();
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    @Override
    public E poll() {
        E returnedElem = this.queue.poll();
        this.polledElements.add(returnedElem);
        return returnedElem;
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public void donePolling(boolean lazySet) {
        Iterator<E> iter = this.polledElements.iterator();
        while (iter.hasNext()) {
            this.pool.offer(iter.next());
            iter.remove();
        }
    }

    @Override
    public final void donePolling() {
        this.donePolling(false);
    }

    @Override
    public final void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void rollback(long count) {
        throw new UnsupportedOperationException();
    }
}

