/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;
import org.mentaqueue.util.NumberUtils;

public class SynchronizedQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16384;
    private final int capacity;
    private final E[] data;
    private long nextOfferValue = -1L;
    private long nextPollValue = -1L;
    private long pollCounter = 0L;
    private long offeringSequence = -1L;
    private long pollingSequence = -1L;
    private final Object offeringLock = new Object();
    private final Object pollingLock = new Object();
    private long maxSeq;

    public SynchronizedQueue(int capacity, Builder<E> builder) {
        NumberUtils.ensurePowerOfTwo(capacity);
        this.capacity = capacity;
        this.data = new Object[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.data[i] = builder.newInstance();
        }
        this.maxSeq = this.findMaxSeqBeforeWrapping();
    }

    public SynchronizedQueue(Builder<E> builder) {
        this(16384, builder);
    }

    public SynchronizedQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public SynchronizedQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long findMaxSeqBeforeWrapping() {
        Object object = this.pollingLock;
        synchronized (object) {
            return (long)this.capacity + this.pollingSequence;
        }
    }

    @Override
    public E nextToDispatch() {
        long index;
        ++this.nextOfferValue;
        if ((index = this.nextOfferValue--) > this.maxSeq) {
            this.maxSeq = this.findMaxSeqBeforeWrapping();
            if (index > this.maxSeq) {
                return null;
            }
        }
        return this.data[(int)(index & (long)(this.capacity - 1))];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean lazySet) {
        Object object = this.offeringLock;
        synchronized (object) {
            this.offeringSequence = this.nextOfferValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long availableToPoll() {
        Object object = this.offeringLock;
        synchronized (object) {
            return this.offeringSequence - this.nextPollValue;
        }
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    @Override
    public E poll() {
        ++this.pollCounter;
        return this.data[(int)(++this.nextPollValue & (long)(this.capacity - 1))];
    }

    @Override
    public E peek() {
        return this.data[(int)(this.nextPollValue & (long)(this.capacity - 1))];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void donePolling(boolean lazySet) {
        Object object = this.pollingLock;
        synchronized (object) {
            this.pollingSequence = this.nextPollValue;
        }
        this.pollCounter = 0L;
    }

    @Override
    public final void donePolling() {
        this.donePolling(false);
    }

    @Override
    public final void rollback() {
        this.rollback(this.pollCounter);
    }

    @Override
    public final void rollback(long count) {
        if (count < 0L || count > this.pollCounter) {
            throw new RuntimeException("Invalid rollback request! polled=" + this.pollCounter + " requested=" + count);
        }
        this.nextPollValue -= count;
        this.pollCounter -= count;
    }
}

