/*
 * MentaQueue => http://mentaqueue.soliveirajr.com
 * Copyright (C) 2012  Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.mentaqueue.util;

public class TransferObject {
	
	private static final int DEFAULT_CAPACITY = 1024;
	
	private long timestamp;
	private int size;
	private byte[] data;

	public TransferObject(int capacity) {
		this.data = new byte[capacity];
	}

	public final int getSize() {
		return size;
	}

	public final byte[] getData() {
		return data;
	}
	
	public final long getTimestamp() {
		return timestamp;
	}
	
	public final void copy(byte[] src) {
		copy(src, src.length);
	}
	
	public final void copy(byte[] src, int size) {
		this.timestamp = System.nanoTime();
		this.size = size;
		System.arraycopy(src, 0, data, 0, size);
	}
	
	public final static Builder<TransferObject> BUILDER = new Builder<TransferObject>() {
		@Override
        public TransferObject newInstance() {
	        return new TransferObject(DEFAULT_CAPACITY);
        }
	};
}
