/*
 * MentaQueue => http://mentaqueue.soliveirajr.com
 * Copyright (C) 2012  Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.mentaqueue.util;

import org.mentaqueue.BatchingQueue;

public class NonBatchingQueue<E> implements BatchingQueue<E> {

	private final BatchingQueue<E> delegate;

	public NonBatchingQueue(BatchingQueue<E> delegate) {
		this.delegate = delegate;
	}

	@Override
	public E nextToDispatch() {
		return delegate.nextToDispatch();
	}

	@Override
	public void flush(boolean lazySet) {
		delegate.flush(lazySet);
	}
	
	@Override
	public final void flush() {
		delegate.flush();
	}

	@Override
	public long availableToPoll() {
		return delegate.availableToPoll() > 0 ? 1 : 0;
	}

	@Override
	public E poll() {
		return delegate.poll();
	}

	@Override
	public void donePolling(boolean lazySet) {
		delegate.donePolling(lazySet);
	}
	
	@Override
	public final void donePolling() {
		delegate.donePolling();
	}

	public BatchingQueue<E> getDelegate() {
		return delegate;
	}
	
	@Override
	public final void rollback() {
		delegate.rollback();
	}
	
	@Override
	public final void rollback(long count) {
		delegate.rollback(count);
	}
	
	@Override
	public final E peek() {
		return delegate.peek();
	}
}