package org.mentaqueue.util;

public class BuilderUtils {
	
	public final static <E> Builder<E> createBuilder(final Class<E> klass) {
		return new Builder<E>() {
			@Override
            public E newInstance() {
	            try {
	            	return klass.newInstance();
	            } catch(Exception e) {
	            	throw new RuntimeException(e);
	            }
            }
		};
	}
}