/*
 * MentaQueue => http://mentaqueue.soliveirajr.com
 * Copyright (C) 2012  Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.mentaqueue;

import static org.mentaqueue.util.BuilderUtils.createBuilder;

import org.mentaqueue.util.Builder;

public class ConcurrentLinkedQueue<E> implements BatchingQueue<E> {

	private final static int DEFAULT_CAPACITY = 1026 * 16;
	
	private final java.util.concurrent.ConcurrentLinkedQueue<E> queue;
	private final Builder<E> builder;
	private E elementToReturn = null;
	
    @SuppressWarnings("unchecked")
    private final E[] temp = (E[]) new Object[DEFAULT_CAPACITY];
    private int tempPointer = 0;

	public ConcurrentLinkedQueue(Builder<E> builder) {
		queue = new java.util.concurrent.ConcurrentLinkedQueue<E>();
		this.builder = builder;
	}

	public ConcurrentLinkedQueue(Class<E> klass) {
		this(createBuilder(klass));
	}
	
	@Override
	public E nextToDispatch() {
		E e = builder.newInstance();
		temp[tempPointer++] = e;
		return e;
	}

	@Override
	public void flush(boolean lazySet) {
		for(int i = 0; i < tempPointer; i++) {
			queue.offer(temp[i]);
			temp[i] = null;
		}
		tempPointer = 0;
	}
	
	@Override
	public final void flush() {
		flush(false);
	}

	@Override
	public long availableToPoll() {
		elementToReturn = queue.poll();
		return elementToReturn != null ? 1 : 0;
	}

	@Override
	public E poll() {
		return elementToReturn;
	}
	
	@Override
	public E peek() {
		return elementToReturn;
	}

	@Override
	public void donePolling(boolean lazySet) {
		elementToReturn = null;
	}
	
	@Override
	public final void donePolling() {
		donePolling(false);
	}
	
	@Override
	public final void rollback() {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public final void rollback(long count) {
		throw new UnsupportedOperationException();
	}
}
