/*
 * MentaQueue => http://mentaqueue.soliveirajr.com
 * Copyright (C) 2012  Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.mentaqueue;

import static org.mentaqueue.util.BuilderUtils.createBuilder;

import org.mentaqueue.util.Builder;

public class BrokenFastQueue<E> implements BatchingQueue<E> {

	private final E[] data;

	@SuppressWarnings("unchecked")
	public BrokenFastQueue(Builder<E> builder) {
		this.data = (E[]) new Object[1];
		this.data[0] = builder.newInstance();
	}
	
	public BrokenFastQueue(Class<E> klass) {
		this(createBuilder(klass));
	}
	
	@Override
	public final E nextToDispatch() {
		return data[0];
	}

	@Override
	public final void flush(boolean lazySet) {
		// NOOP
	}
	
	@Override
	public final void flush() {
		flush(false);
	}

	@Override
	public final long availableToPoll() {
		return 1;
	}

	@Override
	public final E poll() {
		return data[0];
	}

	@Override
	public final void donePolling(boolean lazySet) {
		// NOOP
	}
	
	@Override
	public final void donePolling() {
		donePolling(false);
	}
	
	@Override
	public final void rollback() {
		// NOOP it is broken anyways :)
	}
	
	@Override
	public final void rollback(long count) {
		// NOOP it is broken anyways :)
	}
	
	@Override
	public E peek() {
		return data[0];
	}
}