/*
 * Decompiled with CFR 0.152.
 */
package org.tsutils;

import org.tsutils.AbstractTimestamper;

public class RdtscTimestamper
extends AbstractTimestamper {
    private static final int FACTOR_BITS = 17;
    private static final int WARMUP = 4;
    private static final int COUNT = 4;
    private static final int FACTOR = 1000;
    private static boolean AVAILABLE = false;
    private final long start;
    private long factorValue;
    private final boolean debug;

    public RdtscTimestamper() {
        this(false);
    }

    public RdtscTimestamper(boolean debug) {
        this.debug = debug;
        if (!AVAILABLE) {
            boolean isLinux;
            String os = System.getProperty("os.name").toLowerCase();
            boolean bl = isLinux = os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0;
            if (isLinux) {
                String filename = "lib" + RdtscTimestamper.class.getSimpleName() + ".so";
                throw new IllegalStateException("Cannot find native libraries: " + filename);
            }
            throw new IllegalStateException("Cannot find native libraries!");
        }
        this.start = this.rdtsc();
        this.factorValue = this.calcFrequency(1000, 4, 4);
    }

    private long calcFrequency(int factor, int warmup, int count) {
        for (int i = 0; i < warmup; ++i) {
            long freq = this.estimateFrequency(factor);
            if (!this.debug) continue;
            System.out.println("Warmup frequency: " + freq);
        }
        long[] values = new long[count];
        for (int i = 0; i < count; ++i) {
            values[i] = this.estimateFrequency(factor);
            if (!this.debug) continue;
            System.out.println("Estimated frequency: " + values[i]);
        }
        long finalValue = this.average(values);
        if (this.debug) {
            System.out.println("Average frequency: " + finalValue);
        }
        return finalValue;
    }

    private long average(long[] values) {
        long total = 0L;
        for (int i = 0; i < values.length; ++i) {
            total += values[i];
        }
        return total / (long)values.length;
    }

    private final long tscToNano(long tsc) {
        return tsc * this.factorValue >> 17;
    }

    private final native long rdtsc();

    @Override
    public final long nanoTime() {
        return this.tscToNano(this.rdtsc() - this.start);
    }

    public static boolean isAvailable() {
        return AVAILABLE;
    }

    private long estimateFrequency(int factor) {
        long now;
        long start = System.nanoTime();
        while ((now = System.nanoTime()) == start) {
        }
        long end = start + (long)factor * 1000000L;
        long start0 = this.rdtsc();
        while ((now = System.nanoTime()) < end) {
        }
        long end0 = this.rdtsc();
        end = now;
        return (end - start << 17) / (end0 - start0) - 1L;
    }

    public static void main(String[] args) {
        RdtscTimestamper ts = new RdtscTimestamper(true);
        System.out.println(ts.nanoTime());
        System.out.println(ts.now());
    }

    static {
        try {
            System.loadLibrary(RdtscTimestamper.class.getSimpleName());
            AVAILABLE = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

