/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.wait;

import java.util.concurrent.locks.LockSupport;
import org.mentaqueue.wait.WaitStrategy;

public class YieldParkWaitStrategy
implements WaitStrategy {
    private static final int DEFAULT_YIELD_COUNT = 1000;
    private static final boolean DEFAULT_BACK_OFF = false;
    private final int yieldCount;
    private final boolean parkBackOff;
    private int count = 0;
    private int sleepTime = 0;

    public YieldParkWaitStrategy(int yieldCount, boolean parkBackOff) {
        this.yieldCount = yieldCount;
        this.parkBackOff = parkBackOff;
    }

    public YieldParkWaitStrategy(int yieldCount) {
        this(yieldCount, false);
    }

    public YieldParkWaitStrategy(boolean parkBackOff) {
        this(1000, parkBackOff);
    }

    public YieldParkWaitStrategy() {
        this(1000, false);
    }

    @Override
    public final void waitForOtherThread() {
        if (this.count < this.yieldCount) {
            Thread.yield();
            ++this.count;
        } else if (this.parkBackOff) {
            LockSupport.parkNanos(++this.sleepTime);
        } else {
            LockSupport.parkNanos(1L);
        }
    }

    @Override
    public final void reset() {
        this.count = 0;
        this.sleepTime = 0;
    }
}

