/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.rtt;

import org.mentaaffinity.Affinity;
import org.mentaqueue.AtomicQueue;
import org.mentaqueue.util.DetailedBenchmarker;
import org.mentaqueue.util.MutableLong;

public class TestRTT {
    private static final int BUFFER_SIZE = 1024;

    public static void main(String[] args) throws Exception {
        final int messages = Integer.parseInt(args[0]);
        final AtomicQueue<MutableLong> aToB = new AtomicQueue<MutableLong>(1024, MutableLong.BUILDER);
        final AtomicQueue<MutableLong> bToA = new AtomicQueue<MutableLong>(1024, MutableLong.BUILDER);
        final DetailedBenchmarker bench = new DetailedBenchmarker();
        Thread a = new Thread(new Runnable(){

            private final void send() {
                MutableLong ml;
                while ((ml = (MutableLong)aToB.nextToDispatch()) == null) {
                }
                ml.set(System.nanoTime());
                aToB.flush(false);
            }

            @Override
            public void run() {
                Affinity.bind();
                this.send();
                long count = 0L;
                while (count < (long)messages) {
                    long avail = bToA.availableToPoll();
                    if (avail != 1L) continue;
                    MutableLong ml = (MutableLong)bToA.poll();
                    if (ml == null) {
                        throw new IllegalStateException("This should never happen!");
                    }
                    bench.measure(System.nanoTime() - ml.get());
                    bToA.donePolling(true);
                    if (++count >= (long)messages) continue;
                    this.send();
                }
                Affinity.unbind();
                System.out.println(bench.results());
            }
        }, "Thread-A");
        Thread b = new Thread(new Runnable(){

            @Override
            public void run() {
                Affinity.bind();
                long count = 0L;
                while (count < (long)messages) {
                    MutableLong back;
                    long avail = aToB.availableToPoll();
                    if (avail != 1L) continue;
                    MutableLong ml = (MutableLong)aToB.poll();
                    if (ml != null) {
                        ++count;
                    } else {
                        throw new IllegalStateException("This should never happen!");
                    }
                    long ts = ml.get();
                    aToB.donePolling(true);
                    while ((back = (MutableLong)bToA.nextToDispatch()) == null) {
                    }
                    back.set(ts);
                    bToA.flush(false);
                }
                Affinity.unbind();
            }
        }, "Thread-B");
        Affinity.assignToProcessor(2, a);
        Affinity.assignToProcessor(3, b);
        b.start();
        Thread.sleep(1L);
        a.start();
    }
}

