/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.owt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import org.mentaaffinity.Affinity;
import org.mentaqueue.AtomicQueue;
import org.mentaqueue.util.TransferObject;
import org.mentaqueue.wait.ParkWaitStrategy;

public class TestOWT {
    private static final int BYTEARRAY_SIZE = 2048;
    private static final int BUFFER_SIZE = 1024;
    private static final Random RANDOM = new Random();

    public static void main(String[] args) throws Exception {
        final AtomicQueue<TransferObject> transferQueue = new AtomicQueue<TransferObject>(1024, TransferObject.BUILDER);
        Thread sender = new Thread(new Runnable(){
            private final byte[] src = new byte[2048];

            private final void send(int size) {
                for (int i = 0; i < size; ++i) {
                    this.src[i] = (byte)RANDOM.nextInt(100);
                }
                TransferObject to = (TransferObject)transferQueue.nextToDispatch();
                to.copy(this.src, size);
                transferQueue.flush(false);
            }

            @Override
            public void run() {
                Affinity.bind();
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                try {
                    String line;
                    int size = -1;
                    while ((line = in.readLine()) != null && !line.equals("bye")) {
                        try {
                            if (!line.equals("")) {
                                size = Integer.parseInt(line);
                            }
                            if (size <= 0) continue;
                            this.send(size);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Bad size: " + line);
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Error reading from stdin: " + e);
                }
                Affinity.unbind();
            }
        }, "Thread-Sender");
        Thread receiver = new Thread(new Runnable(){
            private final byte[] dst = new byte[2048];

            @Override
            public void run() {
                Affinity.bind();
                ParkWaitStrategy waitStrategy = new ParkWaitStrategy(true);
                while (true) {
                    if (transferQueue.availableToPoll() > 0L) {
                        TransferObject to = (TransferObject)transferQueue.poll();
                        int size = to.getSize();
                        byte[] data = to.getData();
                        for (int i = 0; i < size; ++i) {
                            this.dst[i] = data[i];
                        }
                        long time = System.nanoTime() - to.getTimestamp();
                        transferQueue.donePolling(true);
                        waitStrategy.reset();
                        System.out.println("Took " + time + " nanos to transfer " + size + " bytes");
                        continue;
                    }
                    waitStrategy.waitForOtherThread();
                }
            }
        }, "Thread-Receiver");
        if (Affinity.isAvailable()) {
            Affinity.assignToProcessor(2, sender);
            Affinity.assignToProcessor(3, receiver);
        } else {
            System.out.println("Not using thread affinity!");
        }
        sender.setDaemon(false);
        receiver.setDaemon(true);
        sender.start();
        receiver.start();
    }
}

