/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import java.util.concurrent.ArrayBlockingQueue;
import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class BlockingArrayQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final ArrayBlockingQueue<E> queue;
    private final Builder<E> builder;
    private final E[] temp = new Object[16416];
    private int tempPointer = 0;

    public BlockingArrayQueue(int capacity, Builder<E> builder) {
        this.queue = new ArrayBlockingQueue(capacity);
        this.builder = builder;
    }

    public BlockingArrayQueue(Class<E> klass) {
        this(16416, BuilderUtils.createBuilder(klass));
    }

    public BlockingArrayQueue(Builder<E> builder) {
        this(16416, builder);
    }

    @Override
    public E nextToDispatch() {
        E e = this.builder.newInstance();
        this.temp[this.tempPointer++] = e;
        return e;
    }

    @Override
    public void flush(boolean lazySet) {
        try {
            for (int i = 0; i < this.tempPointer; ++i) {
                this.queue.put(this.temp[i]);
                this.temp[i] = null;
            }
            this.tempPointer = 0;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    @Override
    public long availableToPoll() {
        return this.queue.size();
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public final void donePolling(boolean lazySet) {
    }

    @Override
    public final void donePolling() {
        this.donePolling(false);
    }

    @Override
    public final void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void rollback(long count) {
        throw new UnsupportedOperationException();
    }
}

