/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;
import org.mentaqueue.util.NumberUtils;
import org.mentaqueue.util.PaddedAtomicLong;

public class AtomicQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16384;
    private final int capacity;
    private final int capacityMinusOne;
    private final E[] data;
    private long lastOfferedSeq = -1L;
    private long lastPolledSeq = -1L;
    private long pollCount = 0L;
    private long maxSeqBeforeWrapping;
    private final PaddedAtomicLong offerSequence = new PaddedAtomicLong(-1L);
    private final PaddedAtomicLong pollSequence = new PaddedAtomicLong(-1L);

    public AtomicQueue(int capacity, Builder<E> builder) {
        NumberUtils.ensurePowerOfTwo(capacity);
        this.capacity = capacity;
        this.capacityMinusOne = capacity - 1;
        this.data = new Object[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.data[i] = builder.newInstance();
        }
        this.maxSeqBeforeWrapping = this.calcMaxSeqBeforeWrapping();
    }

    public AtomicQueue(Builder<E> builder) {
        this(16384, builder);
    }

    public AtomicQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public AtomicQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    private final long calcMaxSeqBeforeWrapping() {
        return this.pollSequence.get() + (long)this.capacity;
    }

    @Override
    public final E nextToDispatch() {
        if (++this.lastOfferedSeq > this.maxSeqBeforeWrapping) {
            this.maxSeqBeforeWrapping = this.calcMaxSeqBeforeWrapping();
            if (this.lastOfferedSeq > this.maxSeqBeforeWrapping) {
                --this.lastOfferedSeq;
                return null;
            }
        }
        return this.data[(int)(this.lastOfferedSeq & (long)this.capacityMinusOne)];
    }

    @Override
    public final void flush(boolean lazySet) {
        if (lazySet) {
            this.offerSequence.lazySet(this.lastOfferedSeq);
        } else {
            this.offerSequence.set(this.lastOfferedSeq);
        }
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    @Override
    public final long availableToPoll() {
        return this.offerSequence.get() - this.lastPolledSeq;
    }

    @Override
    public final E poll() {
        ++this.pollCount;
        return this.data[(int)(++this.lastPolledSeq & (long)this.capacityMinusOne)];
    }

    @Override
    public final E peek() {
        return this.data[(int)(this.lastPolledSeq & (long)this.capacityMinusOne)];
    }

    @Override
    public final void donePolling(boolean lazySet) {
        if (lazySet) {
            this.pollSequence.lazySet(this.lastPolledSeq);
        } else {
            this.pollSequence.set(this.lastPolledSeq);
        }
        this.pollCount = 0L;
    }

    @Override
    public final void rollback() {
        this.rollback(this.pollCount);
    }

    @Override
    public final void rollback(long count) {
        if (count <= 0L || count > this.pollCount) {
            throw new RuntimeException("Invalid rollback request! polled=" + this.pollCount + " requested=" + count);
        }
        this.lastPolledSeq -= count;
        this.pollCount = 0L;
    }

    @Override
    public final void donePolling() {
        this.donePolling(false);
    }
}

