/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.util;

import org.mentalog.Log;
import org.mentalog.util.StringBuilderPool;

public class StringBuilderUtils {
    private static volatile boolean isSynchronized;
    private static ThreadLocal<StringBuilderPool> threadLocal;
    private static final StringBuilderPool singlePool;

    private static final StringBuilderPool getPool() {
        if (isSynchronized) {
            return threadLocal.get();
        }
        return singlePool;
    }

    public static final StringBuilder to_sb(int x) {
        return StringBuilderUtils.getPool().to_sb(x);
    }

    public static final StringBuilder to_sb(float x) {
        return StringBuilderUtils.getPool().to_sb(x);
    }

    public static final StringBuilder to_sb(short x) {
        return StringBuilderUtils.getPool().to_sb(x);
    }

    public static final StringBuilder to_sb(byte x) {
        return StringBuilderUtils.getPool().to_sb(x);
    }

    public static final StringBuilder to_sb(char x) {
        return StringBuilderUtils.getPool().to_sb(x);
    }

    public static final StringBuilder to_sb(boolean x) {
        return StringBuilderUtils.getPool().to_sb(x);
    }

    public static final StringBuilder to_sb(long x) {
        return StringBuilderUtils.getPool().to_sb(x);
    }

    public static final StringBuilder to_sb(double x) {
        return StringBuilderUtils.getPool().to_sb(x);
    }

    public static final void reset() {
        StringBuilderUtils.getPool().reset();
    }

    public static final int getPointer() {
        return StringBuilderUtils.getPool().getPointer();
    }

    static {
        singlePool = new StringBuilderPool();
        threadLocal = new ThreadLocal<StringBuilderPool>(){

            @Override
            protected StringBuilderPool initialValue() {
                return new StringBuilderPool();
            }
        };
        isSynchronized = Log.isSynchronized();
    }
}

