/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.test;

import org.mentalog.Log;
import org.mentalog.util.Benchmarker;

public class GCTest {
    private static final String MSG = "This is a log message not so small that you can use to test. I hope you have fun and it works well!";

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("format HeapTest <max>");
            return;
        }
        int max = Integer.parseInt(args[0]);
        long totalMemory = 0L;
        long logsWithNoMemory = 0L;
        long logsWithMemory = 0L;
        long logsTotal = 0L;
        long logsGC = 0L;
        Benchmarker bench = new Benchmarker();
        Log.setFile(true);
        Log.Warn.log((Object)MSG);
        for (int i = 1; i <= max; ++i) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            bench.mark();
            Log.Warn.log((Object)MSG);
            bench.measure();
            long mem = freeMemory - Runtime.getRuntime().freeMemory();
            ++logsTotal;
            if (mem > 0L) {
                System.out.println("Created " + mem + " bytes after " + i + " log calls");
                totalMemory += mem;
                ++logsWithMemory;
                continue;
            }
            if (mem == 0L) {
                ++logsWithNoMemory;
                continue;
            }
            System.out.println("GC called!");
            ++logsGC;
        }
        System.out.println("Wrote " + logsTotal + " log lines to a file!");
        System.out.println("Logs that allocated memory: " + logsWithMemory + " (" + GCTest.p(logsWithMemory, logsTotal) + ")");
        System.out.println("Logs that did not allocate any memory: " + logsWithNoMemory + " (" + GCTest.p(logsWithNoMemory, logsTotal) + ")");
        System.out.println("Logs that triggered GC: " + logsGC + " (" + GCTest.p(logsGC, logsTotal) + ")");
        System.out.println("Memory allocated: " + totalMemory + " bytes");
        System.out.println("Benchmark: " + bench.results());
        System.out.println();
    }

    private static String p(long l, long total) {
        double d = (double)l / (double)total * 100.0;
        double rounded = (double)Math.round(d * 100.0) / 100.0;
        return String.valueOf(rounded) + "%";
    }
}

