/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog;

import org.mentalog.AsciiEncodable;
import org.mentalog.Logger;
import org.mentalog.util.StringBuilderUtils;

public class LogEvent {
    private static final int MAX = 32;
    private static final int STRING_BUILDER_SIZE = 512;
    private final long[] longs = new long[32];
    private int longPointer = -1;
    private final double[] doubles = new double[32];
    private int doublePointer = -1;
    private final char[] chars = new char[32];
    private int charPointer = -1;
    private final boolean[] bools = new boolean[32];
    private int boolPointer = -1;
    private final StringBuilder[] sbs = new StringBuilder[32];
    private int sbPointer = -1;
    private final Object[] objects = new Object[32];
    private int objectPointer = -1;
    private final Type[] order = new Type[96];
    private int typePointer = -1;
    private int iterationPointer = -1;
    private Logger logger;

    public LogEvent() {
        for (int i = 0; i < 32; ++i) {
            this.sbs[i] = new StringBuilder(512);
        }
    }

    public final void setLogger(Logger logger) {
        this.logger = logger;
    }

    public final int size() {
        return this.typePointer + 1;
    }

    public void flip() {
        this.iterationPointer = -1;
        this.longPointer = 0;
        this.doublePointer = 0;
        this.charPointer = 0;
        this.boolPointer = 0;
        this.sbPointer = 0;
        this.objectPointer = 0;
    }

    public void reset() {
        this.iterationPointer = -1;
        this.typePointer = -1;
        this.longPointer = -1;
        this.doublePointer = -1;
        this.charPointer = -1;
        this.boolPointer = -1;
        this.sbPointer = -1;
        this.objectPointer = -1;
    }

    public boolean hasNext() {
        return this.iterationPointer < this.typePointer;
    }

    public Object next() {
        Type type = this.order[++this.iterationPointer];
        switch (type) {
            case BOOLEAN: {
                return StringBuilderUtils.to_sb(this.bools[this.boolPointer++]);
            }
            case DOUBLE: {
                return StringBuilderUtils.to_sb(this.doubles[this.doublePointer++]);
            }
            case LONG: {
                return StringBuilderUtils.to_sb(this.longs[this.longPointer++]);
            }
            case CHAR: {
                return StringBuilderUtils.to_sb(this.chars[this.charPointer++]);
            }
            case STRING_BUILDER: {
                return this.sbs[this.sbPointer++];
            }
            case OBJECT: {
                return this.objects[this.objectPointer++];
            }
        }
        throw new IllegalStateException("Does not recognize this type: " + (Object)((Object)type));
    }

    public void addCopy(AsciiEncodable cs) {
        this.order[++this.typePointer] = Type.STRING_BUILDER;
        StringBuilder sb = this.sbs[++this.sbPointer];
        sb.setLength(0);
        cs.toAscii(sb);
    }

    public void addCopy(char[] x) {
        this.order[++this.typePointer] = Type.STRING_BUILDER;
        StringBuilder sb = this.sbs[++this.sbPointer];
        sb.setLength(0);
        for (int i = 0; i < x.length; ++i) {
            sb.append(x[i]);
        }
    }

    public void addCopy(byte[] x) {
        this.order[++this.typePointer] = Type.STRING_BUILDER;
        StringBuilder sb = this.sbs[++this.sbPointer];
        sb.setLength(0);
        for (int i = 0; i < x.length; ++i) {
            sb.append((char)x[i]);
        }
    }

    public void addCopy(StringBuilder stringBuilder) {
        this.order[++this.typePointer] = Type.STRING_BUILDER;
        StringBuilder sb = this.sbs[++this.sbPointer];
        sb.setLength(0);
        sb.append((CharSequence)stringBuilder);
    }

    public void addCopy(Object o) {
        this.add(o);
    }

    public void add(long x) {
        this.order[++this.typePointer] = Type.LONG;
        this.longs[++this.longPointer] = x;
    }

    public void add(int x) {
        this.add((long)x);
    }

    public void add(double x) {
        this.order[++this.typePointer] = Type.DOUBLE;
        this.doubles[++this.doublePointer] = x;
    }

    public void add(float x) {
        this.add((double)x);
    }

    public void add(byte x) {
        this.add((long)x);
    }

    public void add(short x) {
        this.add((long)x);
    }

    public void add(char x) {
        this.order[++this.typePointer] = Type.CHAR;
        this.chars[++this.charPointer] = x;
    }

    public void add(boolean x) {
        this.order[++this.typePointer] = Type.BOOLEAN;
        this.bools[++this.boolPointer] = x;
    }

    public void add(Object o) {
        this.order[++this.typePointer] = Type.OBJECT;
        this.objects[++this.objectPointer] = o;
    }

    final void log() {
        int size = this.size();
        Object[] varargs = this.logger.getVarargs(size);
        this.flip();
        for (int i = 0; i < size; ++i) {
            varargs[i] = this.next();
        }
        this.logger.log(false, varargs);
        this.reset();
    }

    private static enum Type {
        LONG,
        DOUBLE,
        CHAR,
        BOOLEAN,
        STRING_BUILDER,
        OBJECT;

    }
}

