/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.mentalog.AsciiEncodable;
import org.mentalog.AsyncThread;
import org.mentalog.Configuration;
import org.mentalog.DefaultLogger;
import org.mentalog.ExtendedDefaultLogger;
import org.mentalog.LogException;
import org.mentalog.LogMessageBuilder;
import org.mentalog.Logger;
import org.mentalog.config.BooleanConfigParam;
import org.mentalog.config.ByteArrayConfigParam;
import org.mentalog.config.BytesConfigParam;
import org.mentalog.config.ConfigParam;
import org.mentalog.config.FloatConfigParam;
import org.mentalog.config.ListConfigParam;
import org.mentalog.config.LogConfigParam;
import org.mentalog.config.StringConfigParam;
import org.mentalog.config.StringsConfigParam;
import org.mentalog.encoder.Encoder;
import org.mentalog.interceptor.Interceptor;
import org.mentalog.timestamper.Timestamper;
import org.mentalog.util.Benchmarker;
import org.mentalog.util.DateTimeFormatter;
import org.mentalog.util.StringBuilderUtils;
import org.mentalog.util.SystemUtils;

public enum Log implements Logger,
LogMessageBuilder
{
    Debug(36),
    Info(32),
    Warn(35),
    Error(34),
    Alert(33),
    Fatal(31);

    static final DateTimeFormatter DATETIME_FORMATTER;
    private static final Log DEFAULT_LOG_LEVEL;
    private static final boolean DEFAULT_LOG_CONSOLE = true;
    private static final boolean DEFAULT_LOG_FILE = false;
    private static final Timestamper DEFAULT_TIMESTAMPER;
    private static final TimeZone DEFAULT_TIMEZONE;
    private static final String DEFAULT_LOG_DIR;
    private static final boolean DEFAULT_SYNCHRONIZED = false;
    private static final boolean DEFAULT_USE_COLORS = false;
    private static final List<Encoder> DEFAULT_ENCODERS;
    private static final boolean DEFAULT_LOG_BYPASSED_CONFIG = false;
    private static final Log DEFAULT_LOG_BYPASSED_CONFIG_LEVEL;
    private static final boolean DEFAULT_NO_SPACE_AFTER_EQUAL_SIGN = true;
    private static final boolean DEFAULT_NO_SPACE_BETWEEN_OBJECTS = false;
    private static final boolean DEFAULT_LOG_CLASS_AND_LINE_NUMBER = false;
    private static final String DEFAULT_LOG_FILTER;
    private static final boolean DEFAULT_LOG_BENCHMARK = false;
    private static final String DEFAULT_LOG_BUFFER_SIZE = "10k";
    private static final String DEFAULT_MEMORY_MAPPED_BUFFER_SIZE = "50m";
    private static final float DEFAULT_MEMORY_MAPPED_BUFFER_THRESHOLD = 0.8f;
    private static final boolean DEFAULT_MEMORY_MAPPED_FILE = false;
    private static final boolean DEFAULT_ALERT_ON_BUFFER_ROLL = false;
    private static final boolean DEFAULT_CACHE_ON_BUFFER_ROLL = true;
    private static final boolean DEFAULT_FORCE_ON_BUFFER_ROLL = false;
    private static final boolean DEFAULT_ASYNCHRONOUS = false;
    private static final boolean isExtension;
    private static BooleanConfigParam logConsole;
    private static BooleanConfigParam logFile;
    private static LogConfigParam logLevel;
    private static StringConfigParam logDir;
    private static BooleanConfigParam isSynchronized;
    private static BooleanConfigParam useColors;
    private static ListConfigParam<Encoder> encoders;
    private static ConfigParam<Timestamper> timestamper;
    private static ConfigParam<TimeZone> timeZone;
    private static BooleanConfigParam logBypassedConfig;
    private static LogConfigParam logBypassedConfigLevel;
    private static BooleanConfigParam noSpaceAfterEqualSign;
    private static BooleanConfigParam noSpaceBetweenObjects;
    private static BooleanConfigParam logClassAndLineNumber;
    private static StringsConfigParam logFilter;
    private static BooleanConfigParam logBenchmark;
    private static BytesConfigParam logBufferSize;
    private static BooleanConfigParam logMemoryMappedFile;
    private static BytesConfigParam logMemoryMappedBufferSize;
    private static FloatConfigParam logMemoryMappedBufferThreshold;
    private static BooleanConfigParam logAlertOnBufferRoll;
    private static BooleanConfigParam logCacheOnBufferRoll;
    private static BooleanConfigParam logForceOnBufferRoll;
    private static BooleanConfigParam logAsynchronous;
    private final String prefix;
    private final ByteArrayConfigParam color;
    private final StringConfigParam logFilename;
    private final BooleanConfigParam enabled;
    private Logger logger = null;

    public static void stop() {
        if (Log.isAsynchronous()) {
            AsyncThread.drainAndStop();
        }
    }

    public static Log fromString(String s) {
        for (Log level : Log.values()) {
            if (!level.toString().equalsIgnoreCase(s)) continue;
            return level;
        }
        return null;
    }

    public static final boolean isAsynchronous() {
        return logAsynchronous.bool();
    }

    public static final void setAsynchronous(boolean b) {
        logAsynchronous.set(b);
    }

    public static final boolean isCacheOnBufferRoll() {
        return logCacheOnBufferRoll.bool();
    }

    public static final boolean isAlertOnBufferRoll() {
        return logAlertOnBufferRoll.bool();
    }

    public static final boolean isForceOnBufferRoll() {
        return logForceOnBufferRoll.bool();
    }

    public static final void setCacheOnBufferRoll(boolean b) {
        logCacheOnBufferRoll.set(b);
    }

    public static final void setAlertOnBufferRoll(boolean b) {
        logAlertOnBufferRoll.set(b);
    }

    public static final void setForceOnBufferRoll(boolean b) {
        logForceOnBufferRoll.set(b);
    }

    public static final float getMemoryMappedBufferThreshold() {
        return ((Float)logMemoryMappedBufferThreshold.value()).floatValue();
    }

    public static final void setMemoryMappedBufferThreshold(float f) {
        logMemoryMappedBufferThreshold.set(Float.valueOf(f));
    }

    public static int getMemoryMappedBufferSize() {
        return (Integer)logMemoryMappedBufferSize.value();
    }

    public static void setMemoryMappedBufferSize(int size) {
        logMemoryMappedBufferSize.set(size);
    }

    public static int getBufferSize() {
        return (Integer)logBufferSize.value();
    }

    public static void setBufferSize(int size) {
        logBufferSize.set(size);
    }

    public static boolean isBenchmark() {
        return logBenchmark.bool();
    }

    public static void setBenchmark(boolean flag) {
        logBenchmark.set(flag);
    }

    public static String[] getFilter() {
        return logFilter.values();
    }

    public static void setFilter(String filter) {
        logFilter.set(filter);
    }

    public static boolean isShowClassAndLineNumber() {
        return logClassAndLineNumber.bool();
    }

    public static void setShowClassAndLineNumber(boolean flag) {
        logClassAndLineNumber.set(flag);
    }

    public static boolean isNoSpaceBetweenObjects() {
        return noSpaceBetweenObjects.bool();
    }

    public static void setNoSpaceBetweenObjects(boolean flag) {
        noSpaceBetweenObjects.set(flag);
    }

    public static boolean isNoSpaceAfterEqualSign() {
        return noSpaceAfterEqualSign.bool();
    }

    public static void setNoSpaceAfterEqualSign(boolean flag) {
        noSpaceAfterEqualSign.set(flag);
    }

    public static List<Encoder> getEncoders() {
        return encoders.values();
    }

    public static void add(Encoder encoder) {
        encoders.add(encoder);
    }

    public static void setEncoders(List<Encoder> encs) {
        encoders.set((Encoder)((Object)encs));
    }

    public static boolean isColors() {
        return useColors.bool();
    }

    public static void setColors(boolean b) {
        boolean oldValue = useColors.bool();
        useColors.set(b);
        if (b != oldValue) {
            Log.closeAll();
        }
    }

    public static boolean isSynchronized() {
        return isSynchronized.bool();
    }

    public static void setSynchronized(boolean flag) {
        boolean oldValue = isSynchronized.bool();
        isSynchronized.set(flag);
        if (flag != oldValue) {
            Log.closeAll();
        }
    }

    public static boolean isConsole() {
        return logConsole.bool();
    }

    public static void setLevel(Log level) {
        logLevel.set(level);
    }

    public static Log getLevel() {
        return (Log)logLevel.value();
    }

    public static void setShowBypassedConfig(boolean flag, Log level) {
        logBypassedConfig.set(flag);
        logBypassedConfigLevel.set(level);
    }

    public static boolean isShowBypassedConfig() {
        return logBypassedConfig.bool();
    }

    public static Log getShowBypassedConfigLevel() {
        return (Log)logBypassedConfigLevel.value();
    }

    public static Timestamper getTimestamper() {
        return timestamper.value();
    }

    public static void setConsole(boolean flag) {
        if (logFile.isForced()) {
            ConfigParam.checkAndLog("logConsole", flag, logConsole.bool());
            return;
        }
        boolean oldValue = logConsole.bool();
        logConsole.set(flag);
        logFile.set(!flag);
        if (logConsole.bool() != oldValue) {
            Log.closeAll();
        }
    }

    public static void setFile(boolean flag) {
        if (logConsole.isForced()) {
            ConfigParam.checkAndLog("logFile", flag, logFile.bool());
            return;
        }
        boolean oldValue = logFile.bool();
        logFile.set(flag);
        logConsole.set(!flag);
        if (logFile.bool() != oldValue) {
            Log.closeAll();
        }
    }

    public static boolean isFile() {
        return logFile.bool();
    }

    public static void setTimestamper(Timestamper ts) {
        if (ts == null) {
            throw new LogException("Cannot set timestamper to null!");
        }
        Timestamper oldValue = timestamper.value();
        timestamper.set(ts);
        if (timestamper.value() != oldValue) {
            Log.closeAll();
        }
    }

    public static void setTimeZone(TimeZone tz) {
        if (tz == null) {
            throw new LogException("Cannot set timezone to null!");
        }
        TimeZone oldValue = timeZone.value();
        timeZone.set(tz);
        if (timeZone.value() != oldValue) {
            DATETIME_FORMATTER.changeTimeZone(tz);
        }
    }

    public static TimeZone getTimeZone() {
        return timeZone.value();
    }

    public static void setDir(String dir) {
        String oldValue = logDir.str();
        logDir.set(dir);
        if (!logDir.str().equals(oldValue)) {
            Log.closeAll();
        }
    }

    public static String getDir() {
        return logDir.str();
    }

    private Log(int color) {
        String name = this.toString();
        this.prefix = name.toUpperCase();
        String defaultFilename = name.toUpperCase() + ".log";
        String logFileArgumentName = "log" + name + "Filename";
        this.logFilename = new StringConfigParam(logFileArgumentName, defaultFilename);
        String colorArgumentName = name.toLowerCase() + "Color";
        this.color = new ByteArrayConfigParam(colorArgumentName, Log.getBytesFromColor(color));
        String enabledArgumentName = name.toLowerCase() + "Enabled";
        this.enabled = new BooleanConfigParam(enabledArgumentName, null);
    }

    private static byte[] getBytesFromColor(int color) {
        return ("\u001b[1;" + String.valueOf(color) + "m").getBytes();
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.addInterceptor(interceptor);
        }
    }

    @Override
    public void removeInterceptor(Interceptor interceptor) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.removeInterceptor(interceptor);
        }
    }

    public void setColor(int color) {
        if (color < 30 || color > 37) {
            throw new LogException("Color can only be in the range 30-37 !");
        }
        byte[] oldValue = this.color.bytes();
        this.color.set(Log.getBytesFromColor(color));
        if (!(!Log.isConsole() && Log.isFile() || Arrays.equals(oldValue, this.color.bytes()))) {
            Log.closeAll();
        }
    }

    public void setFilename(String filename) {
        String oldValue = this.logFilename.str();
        this.logFilename.set(filename);
        if (!oldValue.equals(this.logFilename.str())) {
            Log.closeAll();
        }
    }

    public static void closeAll() {
        for (Log level : Log.values()) {
            level.close();
        }
    }

    public static void add(Interceptor interceptor) {
        for (Log log : Log.values()) {
            log.addInterceptor(interceptor);
        }
    }

    public static void remove(Interceptor interceptor) {
        for (Log log : Log.values()) {
            log.removeInterceptor(interceptor);
        }
    }

    @Override
    public final void close() {
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
    }

    public void logBenchmark() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Benchmarker=").append(Log.isBenchmark() ? "ON" : "OFF");
        sb.append(" Results=[").append(Benchmarker.instance().results()).append("]");
        this.log((Object)sb);
    }

    public boolean isOn(Log level) {
        return this.ordinal() >= level.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Logger getLogger() {
        if (isSynchronized.bool()) {
            Log log = this;
            synchronized (log) {
                return this.getLoggerImpl();
            }
        }
        return this.getLoggerImpl();
    }

    private final Logger getLoggerImpl() {
        if (this.isEnabled()) {
            if (this.logger == null) {
                this.logger = this.createLogger();
            }
            return this.logger;
        }
        this.close();
        return null;
    }

    public static void enableAll(Boolean flag) {
        for (Log log : Log.values()) {
            log.enable(flag);
        }
    }

    public final void enable(Boolean flag) {
        this.enabled.set(flag);
    }

    @Override
    public final boolean isEnabled() {
        if (this.enabled.value() != null && this.enabled.bool()) {
            return true;
        }
        if (this.enabled.value() != null && !this.enabled.bool()) {
            return false;
        }
        if (Log.getLevel() == null) {
            return false;
        }
        return this.isOn(Log.getLevel());
    }

    public static Logger createLogger(String dir, String filename, Timestamper timestamper, boolean isSynchronized) {
        return Log.createLogger(dir, filename, timestamper, isSynchronized, false, -1, encoders.values());
    }

    public static Logger createLogger(String dir, String filename, boolean isSynchronized) {
        return Log.createLogger(dir, filename, DEFAULT_TIMESTAMPER, isSynchronized, false, -1, encoders.values());
    }

    public static Logger createLogger(String dir, String filename, boolean isSynchronized, List<Encoder> encoders) {
        return Log.createLogger(dir, filename, DEFAULT_TIMESTAMPER, isSynchronized, false, -1, encoders);
    }

    public static Logger createMemoryMappedLogger(String dir, String filename, Timestamper timestamper, boolean isSynchronized) {
        return Log.createLogger(dir, filename, timestamper, isSynchronized, true, (Integer)logMemoryMappedBufferSize.value(), encoders.values());
    }

    public static Logger createMemoryMappedLogger(String dir, String filename, boolean isSynchronized) {
        return Log.createLogger(dir, filename, DEFAULT_TIMESTAMPER, isSynchronized, true, (Integer)logMemoryMappedBufferSize.value(), encoders.values());
    }

    public static Logger createMemoryMappedLogger(String dir, String filename, boolean isSynchronized, List<Encoder> encoders) {
        return Log.createLogger(dir, filename, DEFAULT_TIMESTAMPER, isSynchronized, true, (Integer)logMemoryMappedBufferSize.value(), encoders);
    }

    public static Logger createMemoryMappedLogger(String dir, String filename, Timestamper timestamper, boolean isSynchronized, int memoryMappedBufferSize) {
        return Log.createLogger(dir, filename, timestamper, isSynchronized, true, memoryMappedBufferSize, encoders.values());
    }

    public static Logger createMemoryMappedLogger(String dir, String filename, boolean isSynchronized, int memoryMappedBufferSize) {
        return Log.createLogger(dir, filename, DEFAULT_TIMESTAMPER, isSynchronized, true, memoryMappedBufferSize, encoders.values());
    }

    public static Logger createMemoryMappedLogger(String dir, String filename, boolean isSynchronized, List<Encoder> encoders, int memoryMappedBufferSize) {
        return Log.createLogger(dir, filename, DEFAULT_TIMESTAMPER, isSynchronized, true, memoryMappedBufferSize, encoders);
    }

    public static Logger createLogger(String dir, String filename, Timestamper timestamper, boolean isSynchronized, boolean isMemoryMapped, int memoryMappedBufferSize, List<Encoder> encoders) {
        if (!(encoders instanceof ArrayList)) {
            encoders = Log.convertToArrayList(encoders);
        }
        try {
            Log.createDir(dir);
            if (isExtension) {
                return new ExtendedDefaultLogger(dir, filename, timestamper, isSynchronized, isMemoryMapped, memoryMappedBufferSize, encoders, null);
            }
            return new DefaultLogger(dir, filename, timestamper, isSynchronized, isMemoryMapped, memoryMappedBufferSize, encoders, null);
        }
        catch (Exception e) {
            throw new LogException("Cannot create logger!", e);
        }
    }

    private static List<Encoder> convertToArrayList(List<Encoder> encoders) {
        ArrayList<Encoder> list = new ArrayList<Encoder>(encoders.size());
        list.addAll(encoders);
        return list;
    }

    private static void createDir(String dir) {
        File f;
        if (dir != null && !dir.equals("") && !(f = new File(dir)).exists()) {
            f.mkdirs();
        }
    }

    private Logger createLogger() {
        try {
            if (logConsole.isForcedTrue() && logFile.isForcedTrue()) {
                throw new LogException("Cannot configure logConsole and logFile at the same time!");
            }
            if (logConsole.isForcedTrue() || logFile.isForcedFalse() || logConsole.bool() || !logFile.bool()) {
                byte[] c = null;
                if (useColors.bool()) {
                    c = this.color.bytes();
                }
                if (isExtension) {
                    return new ExtendedDefaultLogger(System.out, this.prefix, timestamper.value(), isSynchronized.bool(), c, encoders.values(), this);
                }
                return new DefaultLogger(System.out, this.prefix, timestamper.value(), isSynchronized.bool(), c, encoders.values(), this);
            }
            String fn = this.logFilename.str();
            String dir = logDir.str();
            Log.createDir(dir);
            if (isExtension) {
                return new ExtendedDefaultLogger(dir, fn, timestamper.value(), isSynchronized.bool(), logMemoryMappedFile.bool(), (Integer)logMemoryMappedBufferSize.value(), encoders.values(), this);
            }
            return new DefaultLogger(dir, fn, timestamper.value(), isSynchronized.bool(), logMemoryMappedFile.bool(), (Integer)logMemoryMappedBufferSize.value(), encoders.values(), this);
        }
        catch (IOException e) {
            throw new LogException("Error creating log!", e);
        }
    }

    @Override
    public final void roll() {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.roll();
        }
    }

    @Override
    public final void log(Object ... objects) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(objects);
        }
    }

    public static void main(String[] args) {
        String s = "Hello MentaLog!";
        Log.setLevel(Debug);
        for (Log log : Log.values()) {
            log.log((Object)s);
        }
    }

    @Override
    public void log(boolean async, Object ... objects) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(async, objects);
        }
    }

    @Override
    public final void log(Object s1) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1);
        }
    }

    @Override
    public final void log(Object s1, Object s2) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8, s9);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12, Object s13) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12, Object s13, Object s14) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12, Object s13, Object s14, Object s15) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15);
        }
    }

    @Override
    public final void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12, Object s13, Object s14, Object s15, Object s16) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16);
        }
    }

    public static final StringBuilder to_sb(int x) {
        return StringBuilderUtils.to_sb(x);
    }

    public static final StringBuilder to_sb(long x) {
        return StringBuilderUtils.to_sb(x);
    }

    public static final StringBuilder to_sb(byte b) {
        return StringBuilderUtils.to_sb(b);
    }

    public static final StringBuilder to_sb(short s) {
        return StringBuilderUtils.to_sb(s);
    }

    public static final StringBuilder to_sb(double x) {
        return StringBuilderUtils.to_sb(x);
    }

    public static final StringBuilder to_sb(boolean b) {
        return StringBuilderUtils.to_sb(b);
    }

    public static final StringBuilder to_sb(float f) {
        return StringBuilderUtils.to_sb(f);
    }

    public static final StringBuilder to_sb(char c) {
        return StringBuilderUtils.to_sb(c);
    }

    @Override
    public LogMessageBuilder add(AsciiEncodable cs) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(cs);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(char[] x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(byte[] x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(long x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(int x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(double x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(float x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(byte x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(short x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(char x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(boolean x) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(Object o) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(o);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(StringBuilder sb) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.add(sb);
        }
        return this;
    }

    @Override
    public void flush() {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.flush();
        }
    }

    @Override
    public Object[] getVarargs(int size) {
        Logger logger = this.getLogger();
        if (logger != null) {
            return logger.getVarargs(size);
        }
        return null;
    }

    static {
        DATETIME_FORMATTER = new DateTimeFormatter();
        DEFAULT_LOG_LEVEL = Info;
        DEFAULT_TIMESTAMPER = Timestamper.MILLIS;
        DEFAULT_TIMEZONE = TimeZone.getDefault();
        DEFAULT_LOG_DIR = null;
        DEFAULT_ENCODERS = new ArrayList<Encoder>(16);
        DEFAULT_LOG_BYPASSED_CONFIG_LEVEL = Warn;
        DEFAULT_LOG_FILTER = null;
        isExtension = ExtendedDefaultLogger.isExtension();
        DEFAULT_ENCODERS.add(Encoder.NULL);
        DEFAULT_ENCODERS.add(Encoder.CHAR_SEQUENCE);
        DEFAULT_ENCODERS.add(Encoder.BYTE_OR_CHAR_ARRAY);
        DEFAULT_ENCODERS.add(Encoder.THROWABLE);
        DEFAULT_ENCODERS.add(Encoder.ASCII);
        logConsole = new BooleanConfigParam("logConsole", true);
        logFile = new BooleanConfigParam("logFile", false);
        logLevel = new LogConfigParam("logLevel", DEFAULT_LOG_LEVEL);
        logDir = new StringConfigParam("logDir", DEFAULT_LOG_DIR);
        isSynchronized = new BooleanConfigParam("logSynchronized", false);
        useColors = new BooleanConfigParam("logColors", false);
        encoders = new ListConfigParam<Encoder>("logEncoders", "logAddEncoders, logAddEncoder", "logSetEncoders", DEFAULT_ENCODERS);
        timestamper = new ConfigParam<Timestamper>("logTimestamper", DEFAULT_TIMESTAMPER);
        timeZone = new ConfigParam<TimeZone>("logTimeZone", DEFAULT_TIMEZONE);
        logBypassedConfig = new BooleanConfigParam("logShowBypassedConfig", false);
        logBypassedConfigLevel = new LogConfigParam("logShowBypassedConfigLevel", DEFAULT_LOG_BYPASSED_CONFIG_LEVEL);
        noSpaceAfterEqualSign = new BooleanConfigParam("logNoSpaceAfterEqualSign", true);
        noSpaceBetweenObjects = new BooleanConfigParam("logNoSpaceBetweenObjects", false);
        logClassAndLineNumber = new BooleanConfigParam("logShowClassAndLineNumber", false);
        logFilter = new StringsConfigParam("logFilter", DEFAULT_LOG_FILTER);
        logBenchmark = new BooleanConfigParam("logBenchmark", false);
        logBufferSize = new BytesConfigParam("logBufferSize", DEFAULT_LOG_BUFFER_SIZE);
        logMemoryMappedFile = new BooleanConfigParam("logMemoryMappedFile", false);
        logMemoryMappedBufferSize = new BytesConfigParam("logMemoryMappedBufferSize", DEFAULT_MEMORY_MAPPED_BUFFER_SIZE);
        logMemoryMappedBufferThreshold = new FloatConfigParam("logMemoryMappedBufferThreshold", 0.8f);
        logAlertOnBufferRoll = new BooleanConfigParam("logAlertOnBufferRoll", false);
        logCacheOnBufferRoll = new BooleanConfigParam("logCacheOnBufferRoll", true);
        logForceOnBufferRoll = new BooleanConfigParam("logForceOnBufferRoll", false);
        logAsynchronous = new BooleanConfigParam("logAsynchronous", false);
        String configClassName = SystemUtils.getString("mentaLogConfigClass");
        if (configClassName != null) {
            try {
                Class<?> klass = Class.forName(configClassName);
                Configuration config = (Configuration)klass.newInstance();
                ConfigParam.setForceMode(true);
                config.configure();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot load mentalog configuration: " + configClassName);
            }
            finally {
                ConfigParam.setForceMode(false);
            }
        }
        if (Log.isAsynchronous()) {
            AsyncThread.start();
        }
    }
}

