/*
 * Decompiled with CFR 0.152.
 */
package org.mentaaffinity;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.LongByReference;

class ThreadAffinity {
    ThreadAffinity() {
    }

    public static void setCurrentThreadAffinityMask(long mask) throws Exception {
        CLibrary lib = CLibrary.INSTANCE;
        int cpuMaskSize = 8;
        try {
            int ret = lib.sched_setaffinity(0, 8, new LongByReference(mask));
            if (ret < 0) {
                throw new Exception("sched_setaffinity( 0, (8) , &(" + mask + ") ) return " + ret);
            }
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public static int getCurrentProcessor() {
        return CLibrary.INSTANCE.sched_getcpu();
    }

    public static void nice(int increment) throws Exception {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            int ret = lib.nice(increment);
            if (ret < 0) {
                throw new Exception("nice( " + increment + " ) return " + ret);
            }
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary("c", CLibrary.class);

        public int nice(int var1) throws LastErrorException;

        public int sched_setaffinity(int var1, int var2, PointerType var3) throws LastErrorException;

        public int sched_getcpu() throws LastErrorException;
    }
}

