/*
 * Decompiled with CFR 0.152.
 */
package org.mentaaffinity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.mentaaffinity.AffinityException;
import org.mentaaffinity.Processor;

public class Core {
    private static final Map<Thread, Core> threadToCore = Collections.synchronizedMap(new IdentityHashMap());
    private final int chipId;
    private final int coreId;
    private final List<Processor> processors;
    private final String name;

    public Core(int chipId, int coreId, ArrayList<Processor> processors) {
        if (processors == null || processors.size() == 0) {
            throw new AffinityException("A core must have at least one processor!");
        }
        if (processors.size() > 2) {
            throw new AffinityException("Can only handle a max of 2 processors per core: " + processors.size());
        }
        this.chipId = chipId;
        this.coreId = coreId;
        this.processors = Collections.unmodifiableList(processors);
        this.name = "Core-" + coreId + "." + chipId;
    }

    public int getCoreId() {
        return this.coreId;
    }

    public int getChipId() {
        return this.chipId;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public int getNumberOfProcessors() {
        return this.processors.size();
    }

    static Core getAssignedCoreForThread(Thread t) {
        return threadToCore.get(t);
    }

    synchronized void assign(Thread t1, Thread t2) {
        if (this.getNumberOfProcessors() != 2) {
            throw new AffinityException("The chip does not support hyperthreading!");
        }
        if (!this.isFullyFree()) {
            throw new AffinityException("This core is not fully free!");
        }
        this.processors.get(0).assign(t1);
        this.processors.get(1).assign(t2);
    }

    public synchronized boolean isFullyFree() {
        for (int i = 0; i < this.processors.size(); ++i) {
            Processor p = this.processors.get(i);
            if (p.isFree()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean hasFreeProcessor() {
        return this.getFreeProcessor() != null;
    }

    public synchronized Processor getFreeProcessor() {
        for (int i = 0; i < this.processors.size(); ++i) {
            Processor p = this.processors.get(i);
            if (!p.isFree()) continue;
            return p;
        }
        return null;
    }

    synchronized void assign(Thread thread) {
        if (!this.isFullyFree()) {
            throw new AffinityException("Core is not fully free!");
        }
        if (threadToCore.containsKey(thread)) {
            throw new AffinityException("Thread is already assigned to a core!");
        }
        if (this.processors.size() == 1) {
            throw new AffinityException("Your machine does not support hyper-threading!");
        }
        this.processors.get(0).assign(thread);
        this.processors.get(1).setIdle(thread, true);
        threadToCore.put(thread, this);
    }

    synchronized void unassign(Thread thread) {
        if (!threadToCore.containsKey(thread)) {
            throw new AffinityException("Thread is not assigned to any core!");
        }
        if (this.processors.size() == 1) {
            this.processors.get(0).unassign(thread);
        } else {
            this.processors.get(0).unassign(thread);
            this.processors.get(1).setIdle(thread, false);
        }
        threadToCore.remove(thread);
    }

    public int hashCode() {
        return this.chipId * 31 + this.coreId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Core) {
            Core c = (Core)obj;
            return c.coreId == this.coreId && c.chipId == this.chipId;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

