/*
 * Decompiled with CFR 0.152.
 */
package org.mentaaffinity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mentaaffinity.Core;
import org.mentaaffinity.Processor;

public class Chip {
    private final int chipId;
    private final List<Core> cores;
    private final String name;

    public Chip(int chipId, ArrayList<Core> cores) {
        this.chipId = chipId;
        this.cores = Collections.unmodifiableList(cores);
        this.name = "Chip-" + chipId;
    }

    public int getId() {
        return this.chipId;
    }

    public Core getCore(int coreId) {
        for (int i = 0; i < this.cores.size(); ++i) {
            Core core = this.cores.get(i);
            if (core.getCoreId() != coreId) continue;
            return core;
        }
        return null;
    }

    public List<Core> getCores() {
        return this.cores;
    }

    public synchronized boolean hasFullyFreeCore() {
        return this.getFullyFreeCore() != null;
    }

    public synchronized Core getFullyFreeCore() {
        for (int i = 0; i < this.cores.size(); ++i) {
            Core core = this.cores.get(i);
            if (!core.isFullyFree()) continue;
            return core;
        }
        return null;
    }

    public synchronized boolean hasFreeCore() {
        return this.getFreeCore() != null;
    }

    public synchronized Core getFreeCore() {
        for (int i = 0; i < this.cores.size(); ++i) {
            Core core = this.cores.get(i);
            if (!core.hasFreeProcessor()) continue;
            return core;
        }
        return null;
    }

    public synchronized int getNumberOfFreeCores() {
        int count = 0;
        for (int i = 0; i < this.cores.size(); ++i) {
            Core core = this.cores.get(i);
            if (!core.hasFreeProcessor()) continue;
            ++count;
        }
        return count;
    }

    public int hashCode() {
        return this.chipId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Chip) {
            Chip c = (Chip)obj;
            return c.chipId == this.chipId;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public synchronized void printSituation() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.name).append(":\n");
        for (int i = 0; i < this.cores.size(); ++i) {
            Core core = this.cores.get(i);
            sb.append("    ").append(core).append(":\n");
            List<Processor> processors = core.getProcessors();
            for (int j = 0; j < processors.size(); ++j) {
                Processor p = processors.get(j);
                sb.append("        ").append(p).append(": ");
                sb.append(p.getStatusString()).append("\n");
            }
        }
        System.out.println(sb.toString());
    }
}

