/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.util;

import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.mentaqueue.util.Benchmarker;

public class DetailedBenchmarker
extends Benchmarker {
    private TreeMap<Long, Integer> results = new TreeMap();
    private int size;

    public DetailedBenchmarker() {
    }

    public DetailedBenchmarker(int warmup) {
        super(warmup);
    }

    @Override
    public void reset() {
        super.reset();
        this.size = 0;
        this.results.clear();
    }

    @Override
    public boolean measure(long lastTime) {
        boolean counted = super.measure(lastTime);
        if (counted) {
            Integer count = this.results.get(lastTime);
            if (count == null) {
                this.results.put(lastTime, 1);
            } else {
                this.results.put(lastTime, count + 1);
            }
            ++this.size;
        }
        return counted;
    }

    private String formatPercentage(double x) {
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(3);
        return percentFormat.format(x);
    }

    private void addPercentile(StringBuilder sb, double perc) {
        if (this.results.isEmpty()) {
            return;
        }
        long max = -1L;
        long x = Math.round(perc * (double)this.size);
        Iterator<Map.Entry<Long, Integer>> iter = this.results.entrySet().iterator();
        int i = 0;
        long sum = 0L;
        while (iter.hasNext()) {
            Map.Entry<Long, Integer> entry = iter.next();
            long time = entry.getKey();
            int count = entry.getValue();
            sum += (long)count * time;
            if ((long)(i += count) < x) continue;
            max = time;
            break;
        }
        sb.append(" | ").append(this.formatPercentage(perc)).append(": avg=").append(sum / (long)i).append(" max=").append(max);
    }

    @Override
    public String results() {
        StringBuilder sb = new StringBuilder(super.results());
        this.addPercentile(sb, 0.75);
        this.addPercentile(sb, 0.9);
        this.addPercentile(sb, 0.99);
        this.addPercentile(sb, 0.999);
        this.addPercentile(sb, 0.9999);
        this.addPercentile(sb, 0.99999);
        return sb.toString();
    }
}

