/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.throughput;

import org.mentaaffinity.Affinity;
import org.mentaqueue.ConcurrentLinkedQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.wait.ParkWaitStrategy;

public class TestConcurrentLinkedQueue {
    private static long START_TIME;

    public static void main(String[] args) {
        final long messagesToWarmup = Long.parseLong(args[0]);
        final long messagesToTest = Long.parseLong(args[1]);
        final ConcurrentLinkedQueue<MutableLong> queue = new ConcurrentLinkedQueue<MutableLong>(MutableLong.BUILDER);
        final ParkWaitStrategy producerWaitStrategy = new ParkWaitStrategy(true);
        final ParkWaitStrategy consumerWaitStrategy = new ParkWaitStrategy();
        Thread producer = new Thread(new Runnable(){

            private final void send() {
                MutableLong ml;
                while ((ml = (MutableLong)queue.nextToDispatch()) == null) {
                    producerWaitStrategy.waitForOtherThread();
                }
                ml.set(0L);
                queue.flush(true);
                producerWaitStrategy.reset();
            }

            @Override
            public void run() {
                Affinity.bind();
                int i = 0;
                while ((long)i < messagesToWarmup) {
                    this.send();
                    ++i;
                }
                START_TIME = System.nanoTime();
                i = 0;
                while ((long)i < messagesToTest) {
                    this.send();
                    ++i;
                }
                Affinity.unbind();
            }
        }, "Thread-Producer");
        Thread consumer = new Thread(new Runnable(){

            @Override
            public void run() {
                long avail;
                Affinity.bind();
                long total = messagesToTest + messagesToWarmup;
                for (long count = 0L; count < total; count += avail) {
                    while ((avail = queue.availableToPoll()) == 0L) {
                        consumerWaitStrategy.waitForOtherThread();
                    }
                    consumerWaitStrategy.reset();
                    int i = 0;
                    while ((long)i < avail) {
                        MutableLong ml = (MutableLong)queue.poll();
                        long ts = ml.get();
                        ++i;
                    }
                    queue.donePolling(true);
                }
                long totalTime = System.nanoTime() - START_TIME;
                Affinity.unbind();
                long avg = totalTime / messagesToTest;
                long mps = messagesToTest * 1000000000L / totalTime;
                System.out.println("Finshed throughput test! messagesSent=" + messagesToTest + " mps=" + mps + " avgTime=" + avg);
            }
        }, "Thread-Consumer");
        if (Affinity.isAvailable()) {
            Affinity.assignToProcessor(2, producer);
            Affinity.assignToProcessor(3, consumer);
        } else {
            System.err.println("Thread affinity not available!");
        }
        consumer.start();
        try {
            Thread.sleep(1L);
        }
        catch (Exception e) {
            // empty catch block
        }
        producer.start();
    }

    private static class MutableLong {
        private long value = 0L;
        public static final Builder<MutableLong> BUILDER = new Builder<MutableLong>(){

            @Override
            public MutableLong newInstance() {
                return new MutableLong(-1L);
            }
        };

        public MutableLong(long value) {
            this.value = value;
        }

        public final long get() {
            return this.value;
        }

        public final void set(long value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

